/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.function;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.expression.function.Function;
import com.bstek.ureport.expression.model.data.BindDataListExpressionData;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.expression.model.data.ObjectListExpressionData;
import com.bstek.ureport.model.Cell;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SumFunction
implements Function {
    @Override
    public Object execute(List<ExpressionData<?>> dataList, Context context, Cell currentCell) {
        if (dataList == null || dataList.size() == 0) {
            return null;
        }
        Object singleData = null;
        BigDecimal total = new BigDecimal(0);
        for (ExpressionData<?> exprData : dataList) {
            Iterator iterator;
            if (exprData instanceof ObjectListExpressionData) {
                ObjectListExpressionData listExpr = (ObjectListExpressionData)exprData;
                Object list = listExpr.getData();
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    Object obj = iterator.next();
                    if (obj == null || StringUtils.isBlank((CharSequence)obj.toString())) continue;
                    singleData = obj;
                    BigDecimal bigData = Utils.toBigDecimal(obj);
                    total = total.add(bigData);
                }
                continue;
            }
            if (exprData instanceof ObjectExpressionData) {
                Object obj = exprData.getData();
                singleData = obj;
                if (obj == null || !StringUtils.isNotBlank((CharSequence)obj.toString())) continue;
                BigDecimal bigData = Utils.toBigDecimal(obj);
                total = total.add(bigData);
                continue;
            }
            if (!(exprData instanceof BindDataListExpressionData)) continue;
            BindDataListExpressionData data = (BindDataListExpressionData)exprData;
            Object bindDataList = data.getData();
            iterator = bindDataList.iterator();
            while (iterator.hasNext()) {
                BindData bindData = (BindData)iterator.next();
                Object obj = bindData.getValue();
                if (obj == null) continue;
                singleData = obj;
                BigDecimal bigData = Utils.toBigDecimal(obj);
                total = total.add(bigData);
            }
        }
        if (dataList.size() == 1 && (singleData == null || singleData.equals(""))) {
            return "";
        }
        return total;
    }

    @Override
    public String name() {
        return "sum";
    }
}

