/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.function.math;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.expression.function.math.MathFunction;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.model.Cell;
import java.math.BigDecimal;
import java.util.List;

public class PowFunction
extends MathFunction {
    @Override
    public Object execute(List<ExpressionData<?>> dataList, Context context, Cell currentCell) {
        ExpressionData<?> exprData;
        BigDecimal data = this.buildBigDecimal(dataList);
        int pos = 0;
        if (dataList.size() == 2 && (exprData = dataList.get(1)) instanceof ObjectExpressionData) {
            ObjectExpressionData objData = (ObjectExpressionData)exprData;
            Object obj = objData.getData();
            if (obj == null) {
                throw new ReportComputeException("Pow Function second parameter can not be null.");
            }
            pos = Utils.toBigDecimal(obj).intValue();
        }
        return Math.pow(data.doubleValue(), pos);
    }

    @Override
    public String name() {
        return "pow";
    }
}

