/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.model;

import com.bstek.ureport.exception.ReportParseException;

public enum Op {
    GreatThen,
    EqualsGreatThen,
    LessThen,
    EqualsLessThen,
    Equals,
    NotEquals,
    In,
    NotIn,
    Like;


    public static Op parse(String op) {
        if ((op = op.trim()).equals(">")) {
            return GreatThen;
        }
        if (op.equals(">=")) {
            return EqualsGreatThen;
        }
        if (op.equals("==")) {
            return Equals;
        }
        if (op.equals("<")) {
            return LessThen;
        }
        if (op.equals("<=")) {
            return EqualsLessThen;
        }
        if (op.equals("!=")) {
            return NotEquals;
        }
        if (op.equals("in")) {
            return In;
        }
        if (op.equals("not in") || op.equals("not  in")) {
            return NotIn;
        }
        if (op.equals("like")) {
            return Like;
        }
        throw new ReportParseException("Unknow op :" + op);
    }

    public String toString() {
        switch (this) {
            case GreatThen: {
                return ">";
            }
            case EqualsGreatThen: {
                return ">=";
            }
            case LessThen: {
                return "<";
            }
            case EqualsLessThen: {
                return "<=";
            }
            case Equals: {
                return "==";
            }
            case NotEquals: {
                return "!=";
            }
            case In: {
                return " in ";
            }
            case NotIn: {
                return " not in ";
            }
            case Like: {
                return " like ";
            }
        }
        return super.toString();
    }
}

