/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.model.condition;

import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.expression.ExpressionUtils;
import com.bstek.ureport.expression.model.Condition;
import com.bstek.ureport.expression.model.Op;
import com.bstek.ureport.expression.model.condition.ConditionType;
import com.bstek.ureport.expression.model.condition.Join;
import com.bstek.ureport.expression.model.data.BindDataListExpressionData;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.NoneExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.expression.model.data.ObjectListExpressionData;
import com.bstek.ureport.model.Cell;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

public abstract class BaseCondition
implements Condition {
    protected Op op;
    private String operation;
    private Join join;
    private Condition nextCondition;
    private String left;
    private String right;
    protected Logger log = Logger.getAnonymousLogger();

    @Override
    public final boolean filter(Cell cell, Cell currentCell, Object obj, Context context) {
        Object left = this.computeLeft(cell, currentCell, obj, context);
        Object right = this.computeRight(cell, currentCell, obj, context);
        if (left == null || right == null) {
            return false;
        }
        boolean result = ExpressionUtils.conditionEval(this.op, left, right);
        if (this.join != null && this.nextCondition != null) {
            if (result) {
                if (this.join.equals((Object)Join.and)) {
                    return this.nextCondition.filter(cell, currentCell, obj, context);
                }
                return result;
            }
            if (this.join.equals((Object)Join.and)) {
                return result;
            }
            return this.nextCondition.filter(cell, currentCell, obj, context);
        }
        return result;
    }

    abstract Object computeLeft(Cell var1, Cell var2, Object var3, Context var4);

    abstract Object computeRight(Cell var1, Cell var2, Object var3, Context var4);

    public abstract ConditionType getType();

    protected Object extractExpressionData(ExpressionData<?> data) {
        if (data instanceof ObjectExpressionData) {
            return data.getData();
        }
        if (data instanceof ObjectListExpressionData) {
            ObjectListExpressionData listData = (ObjectListExpressionData)data;
            Object list = listData.getData();
            return list;
        }
        if (data instanceof BindDataListExpressionData) {
            BindDataListExpressionData bindData = (BindDataListExpressionData)data;
            Object bindDataList = bindData.getData();
            ArrayList<Object> list = new ArrayList<Object>();
            Iterator iterator = bindDataList.iterator();
            while (iterator.hasNext()) {
                BindData bd = (BindData)iterator.next();
                list.add(bd.getValue());
            }
            return list;
        }
        if (data instanceof NoneExpressionData) {
            return null;
        }
        return null;
    }

    public void setOp(Op op) {
        this.op = op;
        this.operation = op.toString();
    }

    public Op getOp() {
        return this.op;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public void setNextCondition(Condition nextCondition) {
        this.nextCondition = nextCondition;
    }

    public void setJoin(Join join) {
        this.join = join;
    }

    public Join getJoin() {
        return this.join;
    }

    public String getLeft() {
        return this.left;
    }

    public void setLeft(String left) {
        this.left = left;
    }

    public String getRight() {
        return this.right;
    }

    public void setRight(String right) {
        this.right = right;
    }
}

