/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.expression.model.expr;

import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.expression.model.Operator;
import com.bstek.ureport.expression.model.data.BindDataListExpressionData;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.expression.model.data.ObjectListExpressionData;
import com.bstek.ureport.expression.model.expr.BaseExpression;
import com.bstek.ureport.model.Cell;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JoinExpression
extends BaseExpression {
    private static final long serialVersionUID = -9045259827109781135L;
    private List<Operator> operators;
    private List<BaseExpression> expressions;

    public JoinExpression(List<Operator> operators, List<BaseExpression> expressions) {
        this.operators = operators;
        this.expressions = expressions;
    }

    @Override
    protected ExpressionData<?> compute(Cell cell, Cell currentCell, Context context) {
        ExpressionData<Object> data;
        if (this.expressions.size() == 1) {
            return this.expressions.get(0).compute(cell, currentCell, context);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < this.expressions.size(); ++i) {
            ExpressionData<Object> d;
            BaseExpression expression = this.expressions.get(i);
            data = expression.execute(cell, currentCell, context);
            Object obj = null;
            if (data instanceof ObjectExpressionData) {
                d = (ObjectExpressionData)data;
                obj = ((ObjectExpressionData)d).getData();
            } else if (data instanceof ObjectListExpressionData) {
                d = (ObjectListExpressionData)data;
                obj = ((ObjectListExpressionData)d).getData();
            } else if (data instanceof BindDataListExpressionData) {
                BindDataListExpressionData dataList = (BindDataListExpressionData)data;
                Object bindList = dataList.getData();
                if (bindList.size() == 1) {
                    BindData bindData = (BindData)bindList.get(0);
                    obj = bindData.getValue();
                } else {
                    StringBuilder sb = new StringBuilder();
                    Iterator iterator = bindList.iterator();
                    while (iterator.hasNext()) {
                        BindData bd = (BindData)iterator.next();
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        sb.append(bd.getValue());
                    }
                    obj = sb.toString();
                }
            }
            if (obj == null) {
                obj = "";
            }
            list.add(obj);
        }
        String str = null;
        for (int i = 0; i < list.size(); ++i) {
            data = list.get(i);
            if (str == null) {
                if (data instanceof String) {
                    str = "\"" + data + "\"";
                    continue;
                }
                str = "" + data + "";
                continue;
            }
            Operator op = this.operators.get(i - 1);
            str = data instanceof String ? str + "" + (Object)((Object)op) + "\"" + data + "\"" : str + "" + (Object)((Object)op) + "" + data + "";
        }
        Object obj = context.evalExpr(str);
        return new ObjectExpressionData(obj);
    }

    public List<BaseExpression> getExpressions() {
        return this.expressions;
    }
}

