/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.parser.impl.value;

import com.bstek.ureport.chart.Chart;
import com.bstek.ureport.chart.axes.BaseAxes;
import com.bstek.ureport.chart.axes.ScaleLabel;
import com.bstek.ureport.chart.axes.impl.XAxes;
import com.bstek.ureport.chart.axes.impl.YAxes;
import com.bstek.ureport.chart.dataset.BaseDataset;
import com.bstek.ureport.chart.dataset.CollectType;
import com.bstek.ureport.chart.dataset.Dataset;
import com.bstek.ureport.chart.dataset.impl.BubbleDataset;
import com.bstek.ureport.chart.dataset.impl.ScatterDataset;
import com.bstek.ureport.chart.dataset.impl.category.AreaDataset;
import com.bstek.ureport.chart.dataset.impl.category.BarDataset;
import com.bstek.ureport.chart.dataset.impl.category.CategoryDataset;
import com.bstek.ureport.chart.dataset.impl.category.DoughnutDataset;
import com.bstek.ureport.chart.dataset.impl.category.HorizontalBarDataset;
import com.bstek.ureport.chart.dataset.impl.category.LineDataset;
import com.bstek.ureport.chart.dataset.impl.category.PieDataset;
import com.bstek.ureport.chart.dataset.impl.category.PolarDataset;
import com.bstek.ureport.chart.dataset.impl.category.RadarDataset;
import com.bstek.ureport.chart.dataset.impl.category.SeriesType;
import com.bstek.ureport.chart.option.Easing;
import com.bstek.ureport.chart.option.Option;
import com.bstek.ureport.chart.option.Position;
import com.bstek.ureport.chart.option.impl.AnimationsOption;
import com.bstek.ureport.chart.option.impl.LegendOption;
import com.bstek.ureport.chart.option.impl.TitleOption;
import com.bstek.ureport.definition.value.ChartValue;
import com.bstek.ureport.definition.value.Value;
import com.bstek.ureport.exception.ReportParseException;
import com.bstek.ureport.parser.impl.value.ValueParser;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;

public class ChartValueParser
extends ValueParser {
    @Override
    public Value parse(Element element) {
        ChartValue value = new ChartValue();
        Chart chart = new Chart();
        value.setChart(chart);
        for (Object obj : element.elements()) {
            if (obj == null || !(obj instanceof Element)) continue;
            Element ele = (Element)obj;
            String name = ele.getName();
            if (name.equals("dataset")) {
                Dataset dataset = this.parseDataset(ele);
                chart.setDataset(dataset);
                continue;
            }
            if (name.equals("xaxes")) {
                XAxes xaxes = new XAxes();
                this.parseAxes(ele, xaxes);
                chart.setXaxes(xaxes);
                continue;
            }
            if (name.equals("yaxes")) {
                YAxes yaxes = new YAxes();
                this.parseAxes(ele, yaxes);
                chart.setYaxes(yaxes);
                continue;
            }
            if (!name.equals("option")) continue;
            chart.getOptions().add(this.parseOption(ele));
        }
        return value;
    }

    private Option parseOption(Element element) {
        String type = element.attributeValue("type");
        Option target = null;
        if (type.equals("title")) {
            String position;
            TitleOption option = new TitleOption();
            String display = element.attributeValue("display");
            if (StringUtils.isNotBlank((CharSequence)display)) {
                option.setDisplay(Boolean.valueOf(display));
            }
            if (StringUtils.isNotBlank((CharSequence)(position = element.attributeValue("position")))) {
                option.setPosition(Position.valueOf(position));
            }
            String text = element.attributeValue("text");
            option.setText(text);
            target = option;
        } else if (type.equals("legend")) {
            String position;
            LegendOption option = new LegendOption();
            String display = element.attributeValue("display");
            if (StringUtils.isNotBlank((CharSequence)display)) {
                option.setDisplay(Boolean.valueOf(display));
            }
            if (StringUtils.isNotBlank((CharSequence)(position = element.attributeValue("position")))) {
                option.setPosition(Position.valueOf(position));
            }
            target = option;
        } else if (type.equals("animation")) {
            String easing;
            AnimationsOption option = new AnimationsOption();
            String duration = element.attributeValue("duration");
            if (StringUtils.isNotBlank((CharSequence)duration)) {
                option.setDuration(Integer.valueOf(duration));
            }
            if (StringUtils.isNotBlank((CharSequence)(easing = element.attributeValue("easing")))) {
                option.setEasing(Easing.valueOf(easing));
            }
            target = option;
        }
        if (target != null) {
            return target;
        }
        throw new ReportParseException("Unknow option :" + type);
    }

    private void parseAxes(Element element, BaseAxes axes) {
        String rotation = element.attributeValue("rotation");
        if (StringUtils.isNotBlank((CharSequence)rotation)) {
            axes.setRotation(Integer.valueOf(rotation));
        }
        for (Object obj : element.elements()) {
            Element ele;
            String name;
            if (obj == null || !(obj instanceof Element) || !(name = (ele = (Element)obj).getName()).equals("scale-label")) continue;
            ScaleLabel label = new ScaleLabel();
            String display = ele.attributeValue("display");
            if (StringUtils.isNotBlank((CharSequence)display)) {
                label.setDisplay(Boolean.valueOf(display));
            }
            String labelString = ele.attributeValue("label-string");
            label.setLabelString(labelString);
            axes.setScaleLabel(label);
            break;
        }
    }

    private Dataset parseDataset(Element element) {
        String datasetName;
        BaseDataset ds;
        String type = element.attributeValue("type");
        BaseDataset dataset = null;
        if (type.equals("area")) {
            ds = new AreaDataset();
            dataset = ds;
        } else if (type.equals("line")) {
            ds = new LineDataset();
            dataset = ds;
        } else if (type.equals("bar")) {
            ds = new BarDataset();
            dataset = ds;
        } else if (type.equals("doughnut")) {
            ds = new DoughnutDataset();
            dataset = ds;
        } else if (type.equals("horizontalBar")) {
            ds = new HorizontalBarDataset();
            dataset = ds;
        } else if (type.equals("pie")) {
            ds = new PieDataset();
            dataset = ds;
        } else if (type.equals("polar")) {
            ds = new PolarDataset();
            dataset = ds;
        } else if (type.equals("radar")) {
            ds = new RadarDataset();
            dataset = ds;
        } else if (type.equals("bubble")) {
            ds = new BubbleDataset();
            datasetName = element.attributeValue("dataset-name");
            ((BubbleDataset)ds).setDatasetName(datasetName);
            ((BubbleDataset)ds).setCategoryProperty(element.attributeValue("category-property"));
            ((BubbleDataset)ds).setxProperty(element.attributeValue("x-property"));
            ((BubbleDataset)ds).setyProperty(element.attributeValue("y-property"));
            ((BubbleDataset)ds).setrProperty(element.attributeValue("r-property"));
            dataset = ds;
        } else if (type.equals("scatter")) {
            ds = new ScatterDataset();
            datasetName = element.attributeValue("dataset-name");
            ((ScatterDataset)ds).setDatasetName(datasetName);
            ((ScatterDataset)ds).setCategoryProperty(element.attributeValue("category-property"));
            ((ScatterDataset)ds).setxProperty(element.attributeValue("x-property"));
            ((ScatterDataset)ds).setyProperty(element.attributeValue("y-property"));
            dataset = ds;
        }
        if (dataset != null && dataset instanceof CategoryDataset) {
            String seriesType;
            ds = dataset;
            datasetName = element.attributeValue("dataset-name");
            ((CategoryDataset)ds).setDatasetName(datasetName);
            String format = element.attributeValue("format");
            ((CategoryDataset)ds).setFormat(format);
            String categoryProperty = element.attributeValue("category-property");
            ((CategoryDataset)ds).setCategoryProperty(categoryProperty);
            String valueProperty = element.attributeValue("value-property");
            ((CategoryDataset)ds).setValueProperty(valueProperty);
            String seriesProperty = element.attributeValue("series-property");
            ((CategoryDataset)ds).setSeriesProperty(seriesProperty);
            String collectType = element.attributeValue("collect-type");
            if (StringUtils.isNotBlank((CharSequence)collectType)) {
                ((CategoryDataset)ds).setCollectType(CollectType.valueOf(collectType));
            }
            if (StringUtils.isNotBlank((CharSequence)(seriesType = element.attributeValue("series-type")))) {
                ((CategoryDataset)ds).setSeriesType(SeriesType.valueOf(seriesType));
            }
            ((CategoryDataset)ds).setSeriesText(element.attributeValue("series-text"));
        }
        if (dataset != null) {
            return dataset;
        }
        throw new ReportParseException("Unknow chart type : " + type);
    }
}

