/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.provider.image;

import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.provider.image.ImageProvider;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.WebApplicationContext;

public class DefaultImageProvider
implements ImageProvider,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private String baseWebPath;

    @Override
    public InputStream getImage(String path) {
        try {
            if (path.startsWith("classpath:") || path.startsWith("/WEB-INF")) {
                return this.applicationContext.getResource(path).getInputStream();
            }
            path = this.baseWebPath + path;
            return new FileInputStream(path);
        }
        catch (IOException e) {
            throw new ReportComputeException(e);
        }
    }

    @Override
    public boolean support(String path) {
        if (path.startsWith("classpath:")) {
            return true;
        }
        return this.baseWebPath != null && (path.startsWith("/") || path.startsWith("/WEB-INF"));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof WebApplicationContext) {
            WebApplicationContext context = (WebApplicationContext)applicationContext;
            this.baseWebPath = context.getServletContext().getRealPath("/");
        }
        this.applicationContext = applicationContext;
    }
}

