/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.utils;

import com.bstek.ureport.utils.ArithUtils;
import java.util.Collections;
import java.util.Stack;

public class ElCalculator {
    private static int[] PRIORITY = new int[]{0, 3, 2, 1, -1, 1, 0, 2};

    public void main(String[] args) {
        try {
            String expr = "'gaojie:'+5%26";
            System.out.println(this.eval(expr));
        }
        catch (Exception ex) {
            System.out.println("=" + ex.getMessage() + "=");
        }
    }

    public Object eval(String expression) {
        expression = this.transform(expression);
        Object result = this.calculate(expression);
        return result;
    }

    private String transform(String expression) {
        char[] arr = expression.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            char cc = arr[i];
            if (cc != '-') continue;
            if (i == 0) {
                arr[i] = 126;
                continue;
            }
            char c = arr[i - 1];
            if (c != '+' && c != '-' && c != '*' && c != '/' && c != '(' && c != 'E' && c != 'e') continue;
            arr[i] = 126;
        }
        if (arr[0] == '~' || arr[1] == '(') {
            arr[0] = 45;
            return "0" + new String(arr);
        }
        return new String(arr);
    }

    private Object calculate(String expression) {
        Stack<String> postfixStack = new Stack<String>();
        Stack<Object> resultStack = new Stack<Object>();
        this.prepare(expression, postfixStack);
        Collections.reverse(postfixStack);
        while (!postfixStack.isEmpty()) {
            String currentValue = postfixStack.pop();
            if (currentValue.equals("") || !this.isOperator(currentValue.charAt(0))) {
                if (currentValue.startsWith("\"")) {
                    currentValue = currentValue.substring(1, currentValue.length() - 1);
                }
                currentValue = currentValue.replace("~", "-");
                resultStack.push(currentValue);
                continue;
            }
            String secondValue = resultStack.pop().toString();
            String firstValue = resultStack.pop().toString();
            firstValue = firstValue.replace("~", "-");
            secondValue = secondValue.replace("~", "-");
            Object tempResult = this.calculate(firstValue, secondValue, currentValue.charAt(0));
            resultStack.push(tempResult);
        }
        return resultStack.pop();
    }

    private void prepare(String expression, Stack<String> postfixStack) {
        Stack<Character> opStack = new Stack<Character>();
        opStack.push(Character.valueOf(','));
        char[] arr = expression.toCharArray();
        int currentIndex = 0;
        int count = 0;
        String prevData = null;
        block0: for (int i = 0; i < arr.length; ++i) {
            char currentOp = arr[i];
            if (this.isInvertedComma(currentOp)) {
                currentIndex = i + 1;
                ++i;
                count = 1;
                while (i < arr.length) {
                    currentOp = arr[i];
                    if (this.isInvertedComma(currentOp)) {
                        prevData = new String(arr, currentIndex, count - 1);
                        prevData = "\"" + prevData + "\"";
                        continue block0;
                    }
                    ++i;
                    ++count;
                }
                continue;
            }
            if (this.isOperator(currentOp)) {
                if (prevData != null) {
                    postfixStack.push(prevData);
                    prevData = null;
                } else if (count > 0) {
                    String data = new String(arr, currentIndex, count).trim();
                    postfixStack.push(data);
                }
                char peekOp = ((Character)opStack.peek()).charValue();
                if (currentOp == ')') {
                    while (((Character)opStack.peek()).charValue() != '(') {
                        postfixStack.push(String.valueOf(opStack.pop()));
                    }
                    opStack.pop();
                } else {
                    while (currentOp != '(' && peekOp != ',' && this.compare(currentOp, peekOp)) {
                        postfixStack.push(String.valueOf(opStack.pop()));
                        peekOp = ((Character)opStack.peek()).charValue();
                    }
                    opStack.push(Character.valueOf(currentOp));
                }
                count = 0;
                currentIndex = i + 1;
                continue;
            }
            ++count;
        }
        if (prevData != null) {
            postfixStack.push(prevData);
        } else if (count > 1 || count == 1 && !this.isOperator(arr[currentIndex])) {
            postfixStack.push(new String(arr, currentIndex, count));
        }
        while (((Character)opStack.peek()).charValue() != ',') {
            postfixStack.push(String.valueOf(opStack.pop()));
        }
    }

    private boolean isInvertedComma(char c) {
        return c == '\"';
    }

    private boolean isOperator(char c) {
        return c == '+' || c == '-' || c == '*' || c == '/' || c == '%' || c == '(' || c == ')';
    }

    public boolean compare(char cur, char peek) {
        if (cur == '%') {
            cur = (char)42;
        }
        if (peek == '%') {
            peek = (char)42;
        }
        boolean result = false;
        if (PRIORITY[peek - 40] >= PRIORITY[cur - 40]) {
            result = true;
        }
        return result;
    }

    private Object calculate(String firstValue, String secondValue, char currentOp) {
        Object result = null;
        try {
            switch (currentOp) {
                case '+': {
                    result = ArithUtils.add(firstValue, secondValue);
                    break;
                }
                case '-': {
                    result = ArithUtils.sub(firstValue, secondValue);
                    break;
                }
                case '*': {
                    result = ArithUtils.mul(firstValue, secondValue);
                    break;
                }
                case '/': {
                    result = ArithUtils.div(firstValue, secondValue);
                    break;
                }
                case '%': {
                    result = ArithUtils.com(firstValue, secondValue);
                }
            }
        }
        catch (Exception ex) {
            String b;
            String msg = ex.getMessage() == null ? "" : ex.getMessage();
            String a = firstValue == null ? "null" : firstValue.toString();
            String string = b = secondValue == null ? "null" : secondValue.toString();
            if (currentOp == '+') {
                result = a + b;
            }
            if (currentOp == '/' && msg.indexOf("by zero") != -1) {
                result = "Infinity";
            }
            throw ex;
        }
        return result;
    }
}

