/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.utils;

import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.image.ChartImageProcessor;
import com.bstek.ureport.image.ImageProcessor;
import com.bstek.ureport.image.ImageType;
import com.bstek.ureport.image.StaticImageProcessor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.springframework.util.Base64Utils;

public class ImageUtils {
    private static Map<ImageType, ImageProcessor<?>> imageProcessorMap = new HashMap();

    public static InputStream getImage(ImageType type, Object data) {
        ImageProcessor<?> targetProcessor = imageProcessorMap.get((Object)type);
        if (targetProcessor == null) {
            throw new ReportComputeException("Unknow image type :" + (Object)((Object)type));
        }
        return targetProcessor.getImage(data);
    }

    public static InputStream base64DataToInputStream(String base64Data) {
        byte[] bytes = Base64Utils.decodeFromString((String)base64Data);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        return inputStream;
    }

    public static String getImageBase64Data(ImageType type, Object data) {
        ImageProcessor<?> targetProcessor = imageProcessorMap.get((Object)type);
        if (targetProcessor == null) {
            throw new ReportComputeException("Unknow image type :" + (Object)((Object)type));
        }
        InputStream inputStream = targetProcessor.getImage(data);
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            String string = Base64Utils.encodeToString((byte[])bytes);
            return string;
        }
        catch (Exception ex) {
            throw new ReportComputeException(ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    static {
        StaticImageProcessor staticImageProcessor = new StaticImageProcessor();
        imageProcessorMap.put(ImageType.image, staticImageProcessor);
        ChartImageProcessor chartImageProcessor = new ChartImageProcessor();
        imageProcessorMap.put(ImageType.chart, chartImageProcessor);
    }
}

