/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.service.service.audio;

import com.coze.openapi.api.AudioVoiceAPI;
import com.coze.openapi.client.audio.voices.CloneVoiceReq;
import com.coze.openapi.client.audio.voices.CloneVoiceResp;
import com.coze.openapi.client.audio.voices.ListVoiceReq;
import com.coze.openapi.client.audio.voices.ListVoiceResp;
import com.coze.openapi.client.audio.voices.model.Voice;
import com.coze.openapi.client.common.pagination.PageFetcher;
import com.coze.openapi.client.common.pagination.PageNumBasedPaginator;
import com.coze.openapi.client.common.pagination.PageRequest;
import com.coze.openapi.client.common.pagination.PageResp;
import com.coze.openapi.client.common.pagination.PageResponse;
import com.coze.openapi.service.utils.Utils;
import java.io.File;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;

public class VoiceService {
    private final AudioVoiceAPI api;

    public VoiceService(AudioVoiceAPI api) {
        this.api = api;
    }

    public CloneVoiceResp clone(CloneVoiceReq req) {
        RequestBody voiceName = RequestBody.create((String)req.getVoiceName(), (MediaType)MediaType.parse((String)"text/plain"));
        RequestBody audioFormat = RequestBody.create((String)req.getAudioFormat().getValue(), (MediaType)MediaType.parse((String)"text/plain"));
        RequestBody language = null;
        if (req.getLanguage() != null) {
            language = RequestBody.create((String)req.getLanguage().getValue(), (MediaType)MediaType.parse((String)"text/plain"));
        }
        RequestBody voiceID = null;
        if (req.getVoiceID() != null) {
            voiceID = RequestBody.create((String)req.getVoiceID(), (MediaType)MediaType.parse((String)"text/plain"));
        }
        RequestBody previewText = null;
        if (req.getPreviewText() != null) {
            previewText = RequestBody.create((String)req.getPreviewText(), (MediaType)MediaType.parse((String)"text/plain"));
        }
        RequestBody text = null;
        if (req.getText() != null) {
            text = RequestBody.create((String)req.getText(), (MediaType)MediaType.parse((String)"text/plain"));
        }
        File file = new File(req.getFilePath());
        RequestBody fileBody = RequestBody.create((File)file, (MediaType)MediaType.parse((String)"multipart/form-data"));
        MultipartBody.Part filePart = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)fileBody);
        return Utils.execute(this.api.clone(filePart, voiceName, audioFormat, language, voiceID, previewText, text, req)).getData();
    }

    public PageResp<Voice> list(@NotNull ListVoiceReq req) {
        if (req == null) {
            throw new IllegalArgumentException("req is required");
        }
        Integer pageNum = req.getPageNum();
        Integer pageSize = req.getPageSize();
        Boolean filterSystemVoice = req.getFilterSystemVoice();
        PageFetcher pageFetcher = request -> {
            ListVoiceResp resp = Utils.execute(this.api.list(filterSystemVoice, request.getPageNum(), request.getPageSize(), req)).getData();
            return PageResponse.builder().hasMore(resp.getVoiceList().size() == request.getPageSize().intValue()).data(resp.getVoiceList()).pageNum(request.getPageNum()).pageSize(request.getPageSize()).logID(resp.getLogID()).build();
        };
        PageNumBasedPaginator paginator = new PageNumBasedPaginator(pageFetcher, pageSize);
        PageRequest initialRequest = PageRequest.builder().pageNum(pageNum).pageSize(pageSize).build();
        PageResponse currentPage = pageFetcher.fetch(initialRequest);
        return PageResp.builder().items(currentPage.getData()).iterator(paginator).hasMore(currentPage.isHasMore()).logID(currentPage.getLogID()).build();
    }
}

