/*
 * Decompiled with CFR 0.152.
 */
package com.cq1080.jpa.specification;

import com.cq1080.bean.form.PageForm;
import com.cq1080.bean.form.TimestampFilterItem;
import com.cq1080.meta.MetaUtils;
import com.cq1080.rest.APIError;
import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SpecificationUtil {
    public static <T> PredicateBuilder<T> expire() {
        return SpecificationUtil.expire("expire");
    }

    public static <T> PredicateBuilder<T> expire(String key) {
        return Specifications.and().gt(key, (Comparable)new Timestamp(System.currentTimeMillis()));
    }

    public static <T> PredicateBuilder<T> filter(Object object) {
        return SpecificationUtil.filter(object, null);
    }

    public static <T> PredicateBuilder<T> filter(Object object, PageForm pageForm) {
        Class<?> clazz = object.getClass();
        PredicateBuilder spec = Specifications.and();
        spec.eq("presenceStatus", new Object[]{1});
        List meta = MetaUtils.getSearchableMeta(clazz);
        meta.forEach(it -> {
            try {
                if ("createTime".equals(it.getKey())) {
                    return;
                }
                Field field = clazz.getDeclaredField(it.getKey());
                field.setAccessible(true);
                Object value = field.get(object);
                if (value == null) {
                    return;
                }
                if (field.getType().equals(String.class)) {
                    spec.like(!StringUtils.isEmpty((String)((String)value)), it.getKey(), new String[]{SpecificationUtil.buildLike((String)value)});
                } else {
                    spec.eq(it.getKey(), new Object[]{value});
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        });
        if (pageForm != null && !StringUtils.isEmpty((String)pageForm.getTimes())) {
            try {
                SpecificationUtil.parseTimestampList(pageForm.getTimes()).forEach(item -> spec.between(item.getName(), (Object)new Timestamp(item.getStart()), (Object)new Timestamp(item.getEnd())));
            }
            catch (Exception e) {
                e.printStackTrace();
                APIError.e((Integer)400, (String)"\u683c\u5f0f\u9519\u8bef\uff01\u6b63\u786e\u683c\u5f0f\u4e3a\uff1aname,start,end;name,start,end");
            }
        }
        return spec;
    }

    public static <T> PredicateBuilder<T> exist(PredicateBuilder<T> spec) {
        spec.eq("presenceStatus", new Object[]{1});
        return spec;
    }

    public static String buildLike(String value) {
        return String.format("%%%s%%", value);
    }

    public static List<TimestampFilterItem> parseTimestampList(String times) {
        String[] timeArr = times.split(";");
        ArrayList<TimestampFilterItem> timestampFilterItems = new ArrayList<TimestampFilterItem>();
        for (String time : timeArr) {
            timestampFilterItems.add(SpecificationUtil.parseTimestampFilterItem(time));
        }
        return timestampFilterItems;
    }

    public static TimestampFilterItem parseTimestampFilterItem(String time) {
        String[] split = time.split(",");
        return TimestampFilterItem.builder().name(split[0]).start(Long.valueOf(Long.parseLong(split[1]))).end(Long.valueOf(Long.parseLong(split[2]))).build();
    }

    public static <T> PredicateBuilder<T> timeBetween(PredicateBuilder<T> spec, String key, Long startTime, Long endTime) {
        Long start = 0L;
        Long end = System.currentTimeMillis();
        if (startTime != null) {
            start = startTime;
        }
        if (endTime != null) {
            end = endTime;
        }
        spec.between(key, (Object)new Timestamp(start), (Object)new Timestamp(end));
        return spec;
    }

    public static <T> PredicateBuilder<T> timeBetween(PredicateBuilder<T> spec, Long startTime, Long endTime) {
        return SpecificationUtil.timeBetween(spec, "createTime", startTime, endTime);
    }
}

