/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbRowSet;
import dm.jdbc.driver.Row;
import javax.sql.RowSetInternal;
import javax.sql.RowSetWriter;

public class DmdbRowSetWriter
implements RowSetWriter {
    private StringBuffer ki = null;
    private StringBuffer kj = null;
    private StringBuffer kk = null;
    private int ju = 0;
    private String kl = "";
    private DmdbResultSetMetaData km = null;
    private DmdbPreparedStatement kn = null;
    private DmdbPreparedStatement ko = null;
    private DmdbPreparedStatement kp = null;
    private DmdbConnection fn = null;

    private void initialize(DmdbRowSet dmdbRowSet) {
        this.km = (DmdbResultSetMetaData)dmdbRowSet.getMetaData();
        this.ju = this.km.do_getColumnCount();
        this.fn = dmdbRowSet.getConnection();
        this.kl = dmdbRowSet.getTableName().toUpperCase();
        this.ki = new StringBuffer("UPDATE " + this.kl + " SET ");
        this.kj = new StringBuffer("INSERT INTO " + this.kl + "(");
        this.kk = new StringBuffer("DELETE FROM " + this.kl + " WHERE ");
        int n2 = 0;
        while (n2 < this.ju) {
            if (n2 > 0) {
                this.ki.append(" , ");
                this.kj.append(" , ");
            }
            this.ki.append(this.km.do_getColumnName(n2 + 1)).append(" = ?");
            this.kj.append(this.km.do_getColumnName(n2 + 1));
            ++n2;
        }
        this.kj.append(") VALUES(");
        this.ki.append(" WHERE ");
        n2 = 0;
        while (n2 < this.ju) {
            if (n2 > 0) {
                this.kj.append(",");
                this.ki.append(" AND ");
                this.kk.append(" AND ");
            }
            this.kj.append("?");
            this.ki.append(this.km.do_getColumnName(n2 + 1)).append("= ?");
            this.kk.append(this.km.do_getColumnName(n2 + 1)).append("= ?");
            ++n2;
        }
        this.kj.append(")");
        this.ko = this.fn.do_prepareStatement(this.kj.substring(0, this.kj.length()));
        this.kn = this.fn.do_prepareStatement(this.ki.substring(0, this.ki.length()));
        this.kp = this.fn.do_prepareStatement(this.kk.substring(0, this.kk.length()));
    }

    private boolean insertRow(Row row) {
        this.ko.do_clearParameters();
        int n2 = 0;
        while (n2 < this.ju) {
            Object object = row.getColumn(n2);
            if (object == null) {
                this.ko.do_setNull(n2 + 1, this.km.do_getColumnType(n2 + 1));
            } else {
                this.ko.do_setObject(n2 + 1, object);
            }
            ++n2;
        }
        return 1 == this.ko.do_executeUpdate();
    }

    private boolean updateRow(Row row) {
        if (row.isOriginalWithNull()) {
            return this.updateWithNull(row);
        }
        return this.updateNonNull(row);
    }

    private boolean updateWithNull(Row row) {
        StringBuffer stringBuffer = new StringBuffer("UPDATE " + this.kl + " SET ");
        StringBuffer stringBuffer2 = new StringBuffer(" WHERE ");
        int[] nArray = new int[this.ju];
        int n2 = this.ju;
        int n3 = 0;
        while (n3 < this.ju) {
            if (n3 > 0) {
                stringBuffer.append(" , ");
                stringBuffer2.append(" AND ");
            }
            stringBuffer.append(this.km.do_getColumnName(n3 + 1)).append(" = ?");
            stringBuffer2.append(this.km.do_getColumnName(n3 + 1));
            if (row.isOriginalNull(n3)) {
                nArray[n3] = -1;
                stringBuffer2.append(" IS NULL ");
            } else {
                nArray[n3] = ++n2;
                stringBuffer2.append(" = ? ");
            }
            ++n3;
        }
        stringBuffer.append(stringBuffer2);
        DmdbPreparedStatement dmdbPreparedStatement = this.fn.do_prepareStatement(stringBuffer.substring(0, stringBuffer.length()));
        int n4 = 0;
        while (n4 < this.ju) {
            Object object;
            Object object2 = row.getColumn(n4);
            Object object3 = object = row.isColumnChanged(n4) ? row.getChangedColumn(n4) : object2;
            if (object == null) {
                dmdbPreparedStatement.do_setNull(n4 + 1, this.km.do_getColumnType(n4 + 1));
            } else {
                dmdbPreparedStatement.do_setObject(n4 + 1, object);
            }
            if (nArray[n4] != -1) {
                dmdbPreparedStatement.do_setObject(nArray[n4], object2);
            }
            ++n4;
        }
        n4 = 1 == dmdbPreparedStatement.do_executeUpdate() ? 1 : 0;
        dmdbPreparedStatement.do_close();
        stringBuffer = null;
        stringBuffer2 = null;
        return n4 != 0;
    }

    private boolean updateNonNull(Row row) {
        int n2 = 0;
        while (n2 < this.ju) {
            Object object;
            Object object2 = row.getColumn(n2);
            Object object3 = object = row.isColumnChanged(n2) ? row.getChangedColumn(n2) : object2;
            if (object == null) {
                this.kn.do_setNull(n2 + 1, this.km.do_getColumnType(n2 + 1));
            } else {
                this.kn.do_setObject(n2 + 1, object);
            }
            this.kn.do_setObject(this.ju + n2 + 1, object2);
            ++n2;
        }
        return 1 == this.kn.do_executeUpdate();
    }

    private boolean deleteRow(Row row) {
        if (row.isOriginalWithNull()) {
            return this.deleteWithNull(row);
        }
        return this.deleteNonNull(row);
    }

    private boolean deleteWithNull(Row row) {
        StringBuffer stringBuffer = new StringBuffer("DELETE FROM " + this.kl + " WHERE ");
        int[] nArray = new int[this.ju];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.ju) {
            if (n3 > 0) {
                stringBuffer.append(" AND ");
            }
            if (row.isOriginalNull(n3)) {
                stringBuffer.append(this.km.do_getColumnName(n3 + 1)).append(" IS NULL ");
                nArray[n3] = -1;
            } else {
                stringBuffer.append(this.km.do_getColumnName(n3 + 1)).append(" = ? ");
                nArray[n3] = ++n2;
            }
            ++n3;
        }
        DmdbPreparedStatement dmdbPreparedStatement = this.fn.do_prepareStatement(stringBuffer.substring(0, stringBuffer.length()));
        int n4 = 0;
        while (n4 < this.ju) {
            if (nArray[n4] != -1) {
                dmdbPreparedStatement.do_setObject(nArray[n4], row.getColumn(n4));
            }
            n4 += 1;
        }
        n4 = 1 == dmdbPreparedStatement.do_executeUpdate() ? 1 : 0;
        dmdbPreparedStatement.do_close();
        dmdbPreparedStatement = null;
        stringBuffer = null;
        return n4 != 0;
    }

    private boolean deleteNonNull(Row row) {
        int n2 = 0;
        while (n2 < this.ju) {
            this.kp.do_setObject(n2 + 1, row.getColumn(n2));
            ++n2;
        }
        return 1 == this.kp.do_executeUpdate();
    }

    private void release() {
        this.kj = null;
        if (this.ko != null && !this.ko.closed) {
            this.ko.do_close();
            this.ko = null;
        }
        this.ki = null;
        if (this.kn != null && !this.kn.closed) {
            this.kn.do_close();
            this.kn = null;
        }
        this.kk = null;
        if (this.kp != null && !this.kp.closed) {
            this.kp.do_close();
            this.kp = null;
        }
        this.ju = 0;
        this.km = null;
        this.kl = "";
    }

    @Override
    public boolean writeData(RowSetInternal rowSetInternal) {
        DmdbRowSet dmdbRowSet = (DmdbRowSet)rowSetInternal;
        this.initialize(dmdbRowSet);
        if (this.ju < 1) {
            this.release();
            return true;
        }
        boolean bl = dmdbRowSet.getShowDeleted();
        if (this.fn.do_getAutoCommit()) {
            this.fn.do_setAutoCommit(false);
        }
        dmdbRowSet.setShowDeleted(true);
        dmdbRowSet.beforeFirst();
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        while (dmdbRowSet.next()) {
            Row row;
            if (dmdbRowSet.rowInserted()) {
                if (dmdbRowSet.rowDeleted()) continue;
                row = dmdbRowSet.getCurrentRow();
                bl2 = this.insertRow(row) && bl2;
                continue;
            }
            if (dmdbRowSet.rowUpdated()) {
                row = dmdbRowSet.getCurrentRow();
                bl3 = this.updateRow(row) && bl3;
                continue;
            }
            if (!dmdbRowSet.rowDeleted()) continue;
            row = dmdbRowSet.getCurrentRow();
            boolean bl5 = bl4 = this.deleteRow(row) && bl4;
        }
        if (!(bl2 && bl3 && bl4)) {
            this.fn.do_rollback();
        } else {
            this.fn.do_commit();
            dmdbRowSet.setOriginal();
        }
        dmdbRowSet.setShowDeleted(bl);
        this.release();
        if (!dmdbRowSet.keepConnecting() && this.fn != null && !this.fn.do_isClosed()) {
            this.fn.do_close();
            this.fn = null;
        }
        return true;
    }
}

