/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.ali.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.egzosn.pay.ali.api.AliPayConfigStorage;
import com.egzosn.pay.ali.api.AliPayServiceInf;
import com.egzosn.pay.ali.bean.AliPayBillType;
import com.egzosn.pay.ali.bean.AliPayMessage;
import com.egzosn.pay.ali.bean.AliRefundResult;
import com.egzosn.pay.ali.bean.AliTransactionType;
import com.egzosn.pay.ali.bean.AliTransferType;
import com.egzosn.pay.ali.bean.CertEnvironment;
import com.egzosn.pay.ali.bean.OrderSettle;
import com.egzosn.pay.common.api.BasePayService;
import com.egzosn.pay.common.api.PayConfigStorage;
import com.egzosn.pay.common.bean.AssistOrder;
import com.egzosn.pay.common.bean.BillType;
import com.egzosn.pay.common.bean.MethodType;
import com.egzosn.pay.common.bean.NoticeParams;
import com.egzosn.pay.common.bean.Order;
import com.egzosn.pay.common.bean.OrderParaStructure;
import com.egzosn.pay.common.bean.PayMessage;
import com.egzosn.pay.common.bean.PayOrder;
import com.egzosn.pay.common.bean.PayOutMessage;
import com.egzosn.pay.common.bean.RefundOrder;
import com.egzosn.pay.common.bean.TransactionType;
import com.egzosn.pay.common.bean.TransferOrder;
import com.egzosn.pay.common.bean.TransferType;
import com.egzosn.pay.common.bean.result.PayError;
import com.egzosn.pay.common.bean.result.PayException;
import com.egzosn.pay.common.exception.PayErrorException;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.common.http.UriVariables;
import com.egzosn.pay.common.util.DateUtils;
import com.egzosn.pay.common.util.Util;
import com.egzosn.pay.common.util.sign.SignTextUtils;
import com.egzosn.pay.common.util.sign.SignUtils;
import com.egzosn.pay.common.util.str.StringUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class AliPayService
extends BasePayService<AliPayConfigStorage>
implements AliPayServiceInf {
    private String apiServerUrl;

    public String getReqUrl(TransactionType transactionType) {
        if (StringUtils.isNotEmpty((CharSequence)this.apiServerUrl)) {
            return this.apiServerUrl;
        }
        return ((AliPayConfigStorage)this.payConfigStorage).isTest() ? "https://openapi-sandbox.dl.alipaydev.com/gateway.do" : "https://openapi.alipay.com/gateway.do";
    }

    public String getReqUrl() {
        return this.getReqUrl(null);
    }

    public AliPayService setPayConfigStorage(AliPayConfigStorage payConfigStorage) {
        payConfigStorage.loadCertEnvironment();
        super.setPayConfigStorage((PayConfigStorage)payConfigStorage);
        return this;
    }

    public AliPayService(AliPayConfigStorage payConfigStorage, HttpConfigStorage configStorage) {
        super((PayConfigStorage)payConfigStorage, configStorage);
    }

    public AliPayService(AliPayConfigStorage payConfigStorage) {
        this(payConfigStorage, null);
    }

    @Deprecated
    public boolean verify(Map<String, Object> params) {
        return this.verify(new NoticeParams(params));
    }

    public boolean verify(NoticeParams noticeParams) {
        Map params = noticeParams.getBody();
        if (params.get("sign") == null) {
            this.LOG.debug("\u652f\u4ed8\u5b9d\u652f\u4ed8\u5f02\u5e38\uff1aparams\uff1a{}", (Object)params);
            return false;
        }
        return this.signVerify(params, (String)params.get("sign"));
    }

    public boolean signVerify(Map<String, Object> params, String sign) {
        if (params instanceof JSONObject) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                if ("sign".equals(entry.getKey()) || "alipay_cert_sn".equals(entry.getKey())) continue;
                TreeMap response = new TreeMap((Map)entry.getValue());
                LinkedHashMap linkedHashMap = new LinkedHashMap();
                linkedHashMap.put("code", response.remove("code"));
                linkedHashMap.put("msg", response.remove("msg"));
                linkedHashMap.putAll(response);
                return SignUtils.valueOf((String)((AliPayConfigStorage)this.payConfigStorage).getSignType()).verify(JSON.toJSONString(linkedHashMap), sign, this.getKeyPublic(params), ((AliPayConfigStorage)this.payConfigStorage).getInputCharset());
            }
        }
        return SignUtils.valueOf((String)((AliPayConfigStorage)this.payConfigStorage).getSignType()).verify(params, sign, this.getKeyPublic(params), ((AliPayConfigStorage)this.payConfigStorage).getInputCharset());
    }

    protected String getKeyPublic(Map<String, Object> params) {
        if (!((AliPayConfigStorage)this.payConfigStorage).isCertSign()) {
            return ((AliPayConfigStorage)this.payConfigStorage).getKeyPublic();
        }
        return ((AliPayConfigStorage)this.payConfigStorage).getCertEnvironment().getAliPayPublicKey(this.getAliPayCertSN(params));
    }

    public String getAliPayCertSN(Map<String, Object> respMap) {
        return (String)respMap.get("alipay_cert_sn");
    }

    protected Map<String, Object> setSign(Map<String, Object> parameters) {
        parameters.put("sign_type", ((AliPayConfigStorage)this.payConfigStorage).getSignType());
        String sign = this.createSign(SignTextUtils.parameterText(parameters, (String)"&", (String[])new String[]{"sign"}), ((AliPayConfigStorage)this.payConfigStorage).getInputCharset());
        parameters.put("sign", sign);
        return parameters;
    }

    public Map<String, Object> orderInfo(PayOrder order) {
        return this.setSign(this.getOrder(order));
    }

    private void setNotifyUrl(Map<String, Object> orderInfo, AssistOrder order) {
        OrderParaStructure.loadParameters(orderInfo, (String)"notify_url", (String)((AliPayConfigStorage)this.payConfigStorage).getNotifyUrl());
        OrderParaStructure.loadParameters(orderInfo, (String)"notify_url", (String)order.getNotifyUrl());
        OrderParaStructure.loadParameters(orderInfo, (String)"notify_url", (Order)order);
    }

    private void setReturnUrl(Map<String, Object> orderInfo, PayOrder order) {
        orderInfo.put("return_url", ((AliPayConfigStorage)this.payConfigStorage).getReturnUrl());
        OrderParaStructure.loadParameters(orderInfo, (String)"return_url", (Order)order);
    }

    protected Map<String, Object> getOrder(PayOrder order) {
        Map<String, Object> orderInfo = this.getPublicParameters(order.getTransactionType());
        this.setNotifyUrl(orderInfo, (AssistOrder)order);
        orderInfo.put("format", "json");
        this.setAppAuthToken(orderInfo, order.getAttrs());
        TreeMap<String, Object> bizContent = new TreeMap<String, Object>();
        bizContent.put("body", order.getBody());
        OrderParaStructure.loadParameters(bizContent, (String)"seller_id", (String)((AliPayConfigStorage)this.payConfigStorage).getSeller());
        bizContent.put("subject", order.getSubject());
        bizContent.put("out_trade_no", order.getOutTradeNo());
        bizContent.put("total_amount", Util.conversionAmount((BigDecimal)order.getPrice()).toString());
        switch ((AliTransactionType)order.getTransactionType()) {
            case PAGE: {
                bizContent.put("passback_params", order.getAddition());
                bizContent.put("product_code", "FAST_INSTANT_TRADE_PAY");
                bizContent.put("request_from_url", ((AliPayConfigStorage)this.payConfigStorage).getReturnUrl());
                OrderParaStructure.loadParameters(bizContent, (String)"request_from_url", (Order)order);
                this.setReturnUrl(orderInfo, order);
                break;
            }
            case WAP: {
                bizContent.put("passback_params", order.getAddition());
                bizContent.put("product_code", "QUICK_WAP_PAY");
                OrderParaStructure.loadParameters(bizContent, (String)"product_code", (Order)order);
                bizContent.put("quit_url", ((AliPayConfigStorage)this.payConfigStorage).getReturnUrl());
                OrderParaStructure.loadParameters(bizContent, (String)"quit_url", (Order)order);
                this.setReturnUrl(orderInfo, order);
                break;
            }
            case APP: {
                bizContent.put("passback_params", order.getAddition());
                bizContent.put("product_code", "QUICK_MSECURITY_PAY");
                break;
            }
            case MINAPP: {
                bizContent.put("extend_params", order.getAddition());
                bizContent.put("buyer_id", order.getOpenid());
                bizContent.put("product_code", "FACE_TO_FACE_PAYMENT");
                break;
            }
            case BAR_CODE: 
            case WAVE_CODE: 
            case SECURITY_CODE: {
                bizContent.put("scene", order.getTransactionType().toString().toLowerCase());
                bizContent.put("product_code", "FACE_TO_FACE_PAYMENT");
                bizContent.put("auth_code", order.getAuthCode());
            }
        }
        this.setExpirationTime(bizContent, order);
        bizContent.putAll(order.getAttrs());
        orderInfo.put("biz_content", JSON.toJSONString(bizContent));
        return this.preOrderHandler(orderInfo, order);
    }

    private Map<String, Object> setExpirationTime(Map<String, Object> bizContent, PayOrder order) {
        if (null == order.getExpirationTime()) {
            return bizContent;
        }
        bizContent.put("timeout_express", DateUtils.minutesRemaining((Date)order.getExpirationTime()) + "m");
        switch ((AliTransactionType)order.getTransactionType()) {
            case SWEEPPAY: {
                bizContent.put("qr_code_timeout_express", DateUtils.minutesRemaining((Date)order.getExpirationTime()) + "m");
                break;
            }
            case PAGE: 
            case WAP: 
            case APP: {
                bizContent.put("time_expire", DateUtils.formatDate((Date)order.getExpirationTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                break;
            }
        }
        return bizContent;
    }

    protected Map<String, Object> getPublicParameters(TransactionType transactionType) {
        boolean depositBack = transactionType == AliTransactionType.REFUND_DEPOSITBACK_COMPLETED;
        TreeMap<String, Object> orderInfo = new TreeMap<String, Object>();
        orderInfo.put("app_id", ((AliPayConfigStorage)this.payConfigStorage).getAppId());
        orderInfo.put("charset", ((AliPayConfigStorage)this.payConfigStorage).getInputCharset());
        String method = "method";
        String version = "1.0";
        if (depositBack) {
            method = "msg_method";
            orderInfo.put("utc_timestamp", System.currentTimeMillis());
            version = "1.1";
        } else {
            orderInfo.put("timestamp", DateUtils.format((Date)new Date()));
        }
        orderInfo.put(method, transactionType.getMethod());
        orderInfo.put("version", version);
        this.loadCertSn(orderInfo);
        return orderInfo;
    }

    protected void loadCertSn(Map<String, Object> orderInfo) {
        if (((AliPayConfigStorage)this.payConfigStorage).isCertSign()) {
            CertEnvironment certEnvironment = ((AliPayConfigStorage)this.payConfigStorage).getCertEnvironment();
            OrderParaStructure.loadParameters(orderInfo, (String)"app_cert_sn", (String)certEnvironment.getMerchantCertSN());
            OrderParaStructure.loadParameters(orderInfo, (String)"alipay_root_cert_sn", (String)certEnvironment.getRootCertSN());
        }
    }

    public PayOutMessage getPayOutMessage(String code, String message) {
        return PayOutMessage.TEXT().content(code.toLowerCase()).build();
    }

    public PayOutMessage successPayOutMessage(PayMessage payMessage) {
        return PayOutMessage.TEXT().content("success").build();
    }

    public String toPay(PayOrder order) {
        if (null == order.getTransactionType()) {
            order.setTransactionType((TransactionType)AliTransactionType.PAGE);
        } else if (order.getTransactionType() != AliTransactionType.PAGE && order.getTransactionType() != AliTransactionType.WAP) {
            throw new PayErrorException((PayError)new PayException("-1", "\u9519\u8bef\u7684\u4ea4\u6613\u7c7b\u578b:" + order.getTransactionType()));
        }
        return super.toPay(order);
    }

    public String buildRequest(Map<String, Object> orderInfo, MethodType method) {
        StringBuilder formHtml = new StringBuilder();
        formHtml.append("<form id=\"_alipaysubmit_\" name=\"alipaysubmit\" action=\"");
        String bizContent = (String)orderInfo.remove("biz_content");
        formHtml.append(this.getReqUrl()).append("?").append(UriVariables.getMapToParameters(orderInfo)).append("\" method=\"").append(method.name().toLowerCase()).append("\">");
        formHtml.append("<input type=\"hidden\" name=\"biz_content\" value='").append(bizContent).append("'/>");
        formHtml.append("</form>");
        formHtml.append("<script>document.forms['_alipaysubmit_'].submit();</script>");
        return formHtml.toString();
    }

    public String getQrPay(PayOrder order) {
        order.setTransactionType((TransactionType)AliTransactionType.SWEEPPAY);
        Map<String, Object> orderInfo = this.orderInfo(order);
        JSONObject result = (JSONObject)this.getHttpRequestTemplate().postForObject(this.getReqUrl() + "?" + UriVariables.getMapToParameters(orderInfo), null, JSONObject.class, new Object[0]);
        JSONObject response = result.getJSONObject("alipay_trade_precreate_response");
        if ("10000".equals(response.getString("code"))) {
            return response.getString("qr_code");
        }
        throw new PayErrorException((PayError)new PayException(response.getString("code"), response.getString("msg"), result.toJSONString()));
    }

    public Map<String, Object> microPay(PayOrder order) {
        if (null == order.getTransactionType()) {
            order.setTransactionType((TransactionType)AliTransactionType.BAR_CODE);
        } else if (order.getTransactionType() != AliTransactionType.BAR_CODE && order.getTransactionType() != AliTransactionType.WAVE_CODE && order.getTransactionType() != AliTransactionType.SECURITY_CODE) {
            throw new PayErrorException((PayError)new PayException("-1", "\u9519\u8bef\u7684\u4ea4\u6613\u7c7b\u578b:" + order.getTransactionType()));
        }
        Map<String, Object> orderInfo = this.orderInfo(order);
        JSONObject result = (JSONObject)this.getHttpRequestTemplate().postForObject(this.getReqUrl() + "?" + UriVariables.getMapToParameters(orderInfo), null, JSONObject.class, new Object[0]);
        JSONObject response = result.getJSONObject("alipay_trade_pay_response");
        if (!"10000".equals(response.getString("code"))) {
            this.LOG.info("\u6536\u6b3e\u5931\u8d25");
        }
        return result;
    }

    public Map<String, Object> settle(OrderSettle order) {
        Map<String, Object> parameters = this.getPublicParameters(AliTransactionType.SETTLE);
        this.setAppAuthToken(parameters, order.getAttrs());
        Map<String, Object> bizContent = order.toBizContent();
        bizContent.putAll(order.getAttrs());
        parameters.put("biz_content", JSON.toJSONString(bizContent));
        this.setSign(parameters);
        return (Map)this.getHttpRequestTemplate().postForObject(this.getReqUrl() + "?" + UriVariables.getMapToParameters(parameters), null, JSONObject.class, new Object[0]);
    }

    public Map<String, Object> query(String tradeNo, String outTradeNo) {
        return this.secondaryInterface(tradeNo, outTradeNo, AliTransactionType.QUERY);
    }

    public Map<String, Object> query(AssistOrder assistOrder) {
        Map<String, Object> parameters = this.getPublicParameters(assistOrder.getTransactionType());
        TreeMap<String, Object> bizContent = new TreeMap<String, Object>();
        OrderParaStructure.loadParameters(bizContent, (String)"query_options", (Order)assistOrder);
        parameters.put("biz_content", JSON.toJSONString(this.getBizContent(assistOrder.getTradeNo(), assistOrder.getOutTradeNo(), bizContent)));
        this.setSign(parameters);
        return (Map)this.requestTemplate.getForObject(this.getReqUrl(assistOrder.getTransactionType()) + "?" + UriVariables.getMapToParameters(parameters), JSONObject.class, new Object[0]);
    }

    public Map<String, Object> close(String tradeNo, String outTradeNo) {
        return this.secondaryInterface(tradeNo, outTradeNo, AliTransactionType.CLOSE);
    }

    public Map<String, Object> close(AssistOrder assistOrder) {
        return this.secondaryInterface(assistOrder.getTradeNo(), assistOrder.getOutTradeNo(), AliTransactionType.CLOSE);
    }

    public Map<String, Object> cancel(String tradeNo, String outTradeNo) {
        return this.secondaryInterface(tradeNo, outTradeNo, AliTransactionType.CANCEL);
    }

    protected void setAppAuthToken(Map<String, Object> parameters, Map<String, Object> attrs) {
        this.setAppAuthToken(parameters);
        OrderParaStructure.loadParameters(parameters, (String)"app_auth_token", (String)((String)attrs.remove("app_auth_token")));
    }

    protected void setAppAuthToken(Map<String, Object> parameters) {
        OrderParaStructure.loadParameters(parameters, (String)"app_auth_token", (String)((AliPayConfigStorage)this.payConfigStorage).getAppAuthToken());
    }

    public AliRefundResult refund(RefundOrder refundOrder) {
        if (null != refundOrder.getTransactionType() && refundOrder.getTransactionType() == AliTransactionType.REFUND_DEPOSITBACK_COMPLETED) {
            String status = this.refundDepositBackCompleted(refundOrder);
            AliRefundResult result = new AliRefundResult();
            result.setCode(status);
            return result;
        }
        Map<String, Object> parameters = this.getPublicParameters(AliTransactionType.REFUND);
        this.setAppAuthToken(parameters, refundOrder.getAttrs());
        Map<String, Object> bizContent = this.getBizContent(refundOrder.getTradeNo(), refundOrder.getOutTradeNo(), null);
        OrderParaStructure.loadParameters(bizContent, (String)"out_request_no", (String)refundOrder.getRefundNo());
        bizContent.put("refund_amount", Util.conversionAmount((BigDecimal)refundOrder.getRefundAmount()));
        OrderParaStructure.loadParameters(bizContent, (String)"refund_reason", (String)refundOrder.getDescription());
        OrderParaStructure.loadParameters(bizContent, (String)"refund_reason", (Order)refundOrder);
        OrderParaStructure.loadParameters(bizContent, (String)"refund_royalty_parameters", (Order)refundOrder);
        OrderParaStructure.loadParameters(bizContent, (String)"query_options", (Order)refundOrder);
        parameters.put("biz_content", JSON.toJSONString(bizContent));
        this.setSign(parameters);
        JSONObject result = (JSONObject)this.requestTemplate.getForObject(this.getReqUrl() + "?" + UriVariables.getMapToParameters(parameters), JSONObject.class, new Object[0]);
        JSONObject refundResponse = result.getJSONObject("alipay_trade_refund_response");
        AliRefundResult refundResult = AliRefundResult.create((Map<String, Object>)refundResponse);
        refundResult.setOutRequestNo(refundOrder.getRefundNo());
        return refundResult;
    }

    public Map<String, Object> refundquery(RefundOrder refundOrder) {
        Map<String, Object> parameters = this.getPublicParameters(AliTransactionType.REFUNDQUERY);
        this.setAppAuthToken(parameters, refundOrder.getAttrs());
        Map<String, Object> bizContent = this.getBizContent(refundOrder.getTradeNo(), refundOrder.getOutTradeNo(), null);
        OrderParaStructure.loadParameters(bizContent, (String)"out_request_no", (String)refundOrder.getRefundNo());
        OrderParaStructure.loadParameters(bizContent, (String)"query_options", (Order)refundOrder);
        parameters.put("biz_content", JSON.toJSONString(bizContent));
        this.setSign(parameters);
        return (Map)this.requestTemplate.getForObject(this.getReqUrl() + "?" + UriVariables.getMapToParameters(parameters), JSONObject.class, new Object[0]);
    }

    public Map<String, Object> downloadBill(Date billDate, String billType) {
        return this.downloadBill(billDate, "trade".equals(billType) ? AliPayBillType.TRADE_DAY : AliPayBillType.SIGNCUSTOMER_DAY);
    }

    public Map<String, Object> downloadBill(Date billDate, BillType billType) {
        Map<String, Object> parameters = this.getPublicParameters(AliTransactionType.DOWNLOADBILL);
        TreeMap<String, String> bizContent = new TreeMap<String, String>();
        bizContent.put("bill_type", billType.getType());
        bizContent.put("bill_date", DateUtils.formatDate((Date)billDate, (String)billType.getDatePattern()));
        String bizContentStr = JSON.toJSONString(bizContent);
        parameters.put("biz_content", bizContentStr);
        this.setSign(parameters);
        HashMap bizContentMap = new HashMap(1);
        parameters.put("biz_content", bizContentStr);
        return (Map)this.requestTemplate.postForObject(this.getReqUrl() + "?" + UriVariables.getMapToParameters(parameters), bizContentMap, JSONObject.class, new Object[0]);
    }

    public Map<String, Object> secondaryInterface(Object tradeNoOrBillDate, String outTradeNoBillType, TransactionType transactionType) {
        if (transactionType == AliTransactionType.REFUND) {
            throw new PayErrorException((PayError)new PayException("failure", "\u901a\u7528\u63a5\u53e3\u4e0d\u652f\u6301:" + transactionType));
        }
        if (transactionType == AliTransactionType.DOWNLOADBILL) {
            if (tradeNoOrBillDate instanceof Date) {
                return this.downloadBill((Date)tradeNoOrBillDate, outTradeNoBillType);
            }
            throw new PayErrorException((PayError)new PayException("failure", "\u975e\u6cd5\u7c7b\u578b\u5f02\u5e38:" + tradeNoOrBillDate.getClass()));
        }
        Map<String, Object> parameters = this.getPublicParameters(transactionType);
        parameters.put("biz_content", this.getContentToJson((String)tradeNoOrBillDate, outTradeNoBillType));
        this.setSign(parameters);
        return (Map)this.requestTemplate.getForObject(this.getReqUrl(transactionType) + "?" + UriVariables.getMapToParameters(parameters), JSONObject.class, new Object[0]);
    }

    public Map<String, Object> transfer(TransferOrder order) {
        TransferType transferType = order.getTransferType();
        Map<String, Object> parameters = this.getPublicParameters((TransactionType)transferType);
        this.setAppAuthToken(parameters, order.getAttrs());
        LinkedHashMap<String, Object> bizContent = new LinkedHashMap<String, Object>();
        bizContent.put("out_biz_no", order.getOutNo());
        bizContent.put("trans_amount", order.getAmount());
        transferType.setAttr(bizContent, order);
        OrderParaStructure.loadParameters(bizContent, (String)"order_title", (Order)order);
        OrderParaStructure.loadParameters(bizContent, (String)"original_order_id", (Order)order);
        this.setPayeeInfo(bizContent, (Order)order);
        bizContent.put("remark", order.getRemark());
        OrderParaStructure.loadParameters(bizContent, (String)"business_params", (Order)order);
        parameters.put("biz_content", JSON.toJSONString(bizContent));
        this.setSign(parameters);
        return (Map)this.getHttpRequestTemplate().postForObject(this.getReqUrl() + "?" + UriVariables.getMapToParameters(parameters), null, JSONObject.class, new Object[0]);
    }

    private Map<String, Object> setPayeeInfo(Map<String, Object> bizContent, Order order) {
        Object attr = order.getAttr("payee_info");
        if (attr instanceof String) {
            bizContent.put("payee_info", attr);
        }
        if (attr instanceof TreeMap) {
            bizContent.put("payee_info", attr);
        }
        if (attr instanceof Map) {
            TreeMap payeeInfo = new TreeMap((Map)attr);
            bizContent.put("payee_info", payeeInfo);
        }
        return bizContent;
    }

    public Map<String, Object> transferQuery(String outNo, String tradeNo) {
        Map<String, Object> parameters = this.getPublicParameters((TransactionType)AliTransferType.TRANS_QUERY);
        TreeMap<String, String> bizContent = new TreeMap<String, String>();
        if (StringUtils.isEmpty((CharSequence)outNo)) {
            bizContent.put("order_id", tradeNo);
        } else {
            bizContent.put("out_biz_no", outNo);
        }
        parameters.put("biz_content", JSON.toJSONString(bizContent));
        this.setSign(parameters);
        return (Map)this.getHttpRequestTemplate().postForObject(this.getReqUrl() + "?" + UriVariables.getMapToParameters(parameters), null, JSONObject.class, new Object[0]);
    }

    private Map<String, Object> getBizContent(String tradeNo, String outTradeNo, Map<String, Object> bizContent) {
        if (null == bizContent) {
            bizContent = new TreeMap<String, Object>();
        }
        if (!StringUtils.isEmpty((CharSequence)outTradeNo)) {
            bizContent.put("out_trade_no", outTradeNo);
        }
        if (!StringUtils.isEmpty((CharSequence)tradeNo)) {
            bizContent.put("trade_no", tradeNo);
        }
        return bizContent;
    }

    private String getContentToJson(String tradeNo, String outTradeNo) {
        return JSON.toJSONString(this.getBizContent(tradeNo, outTradeNo, null));
    }

    public PayMessage createMessage(Map<String, Object> message) {
        return AliPayMessage.create(message);
    }

    @Override
    public String refundDepositBackCompleted(RefundOrder refundOrder) {
        Map<String, Object> parameters = this.getPublicParameters(refundOrder.getTransactionType());
        OrderParaStructure.loadParameters(parameters, (String)"notify_id", (Order)refundOrder);
        OrderParaStructure.loadParameters(parameters, (String)"msg_type", (Order)refundOrder);
        OrderParaStructure.loadParameters(parameters, (String)"msg_uid", (Order)refundOrder);
        OrderParaStructure.loadParameters(parameters, (String)"msg_app_id", (Order)refundOrder);
        Map<String, Object> bizContent = this.getBizContent(refundOrder.getTradeNo(), refundOrder.getOutTradeNo(), null);
        OrderParaStructure.loadParameters(bizContent, (String)"out_request_no", (String)refundOrder.getRefundNo());
        OrderParaStructure.loadParameters(bizContent, (String)"dback_status", (Order)refundOrder);
        bizContent.put("dback_amount", refundOrder.getRefundAmount());
        OrderParaStructure.loadParameters(bizContent, (String)"dback_amount", (Order)refundOrder);
        OrderParaStructure.loadParameters(bizContent, (String)"bank_ack_time", (Order)refundOrder);
        OrderParaStructure.loadParameters(bizContent, (String)"est_bank_receipt_time", (Order)refundOrder);
        parameters.put("biz_content", JSON.toJSONString(bizContent));
        this.setSign(parameters);
        return null;
    }

    @Override
    public AliPayServiceInf setApiServerUrl(String apiServerUrl) {
        this.apiServerUrl = apiServerUrl;
        return this;
    }
}

