/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.research.trap.impl.http;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HTTPServletUtil {
    public static void addCorsHeaders(HttpServletRequest req, HttpServletResponse resp) {
        String origin = req.getHeader("Origin");
        if (origin == null) {
            origin = "null";
        }
        origin = origin.replaceAll("[\\n\\r]", "");
        resp.setHeader("Allow", "GET,PUT,POST,DELETE,OPTIONS");
        resp.setHeader("Access-Control-Allow-Origin", origin);
        resp.setHeader("Access-Control-Allow-Methods", "GET,PUT,POST,DELETE,OPTIONS");
        resp.setHeader("Access-Control-Allow-Headers", "Content-Type");
        resp.setHeader("Access-Control-Request-Methods", "GET,PUT,POST,DELETE,OPTIONS");
        resp.setHeader("Access-Control-Request-Headers", "Content-Type");
        resp.setHeader("Access-Control-Max-Age", "3600");
    }

    public static String[] getContexts(HttpServletRequest request, String prefix) {
        String ctx = "";
        String sess = "";
        String path = request.getPathInfo();
        if (path != null) {
            String[] parts;
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if ((parts = path.split("/")).length >= 2) {
                ctx = parts[0];
                sess = parts[1];
            } else {
                ctx = path;
            }
        }
        String[] arr = new String[]{request.getContextPath(), ctx, sess};
        return arr;
    }
}

