/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.research.trap.utils;

import com.ericsson.research.trap.utils.Block;

class BlockImpl
extends Block {
    private final String name;
    private long timeout = 10000L;
    private boolean unlocked;

    public BlockImpl(String name) {
        this.name = name;
    }

    public BlockImpl(String name, long timeout) {
        this.name = name;
        this.timeout = timeout;
    }

    public synchronized void block() {
        if (this.unlocked) {
            return;
        }
        try {
            this.wait(this.timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.unlocked) {
            throw new RuntimeException("Timeout during " + this.name);
        }
    }

    public synchronized void unblock() {
        this.unlocked = true;
        this.notifyAll();
    }

    public synchronized void reset() {
        this.unblock();
        this.unlocked = false;
    }
}

