/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.research.trap.utils;

public class ByteConverter {
    public static byte[] toBigEndian(int i) {
        byte[] arr = new byte[4];
        return ByteConverter.toBigEndian(i, arr, 0);
    }

    public static byte[] toBigEndian(int src, byte[] arr, int off) {
        arr[off + 0] = (byte)(src >> 24);
        arr[off + 1] = (byte)(src >> 16 & 0xFF);
        arr[off + 2] = (byte)(src >> 8 & 0xFF);
        arr[off + 3] = (byte)(src >> 0 & 0xFF);
        return arr;
    }

    public static int fromBigEndian(byte[] arr, int offset) {
        int rv = 0;
        rv |= (arr[offset + 0] & 0xFF) << 24;
        rv |= (arr[offset + 1] & 0xFF) << 16;
        rv |= (arr[offset + 2] & 0xFF) << 8;
        return rv |= (arr[offset + 3] & 0xFF) << 0;
    }

    public static byte[] toBigEndian7(int src) {
        byte[] rv = new byte[]{(byte)ByteConverter.getBits(src, 4, 11), (byte)ByteConverter.getBits(src, 11, 18), (byte)ByteConverter.getBits(src, 18, 25), (byte)ByteConverter.getBits(src, 25, 32)};
        return rv;
    }

    public static int fromBigEndian7(byte[] arr, int offset) {
        int rv = 0;
        rv |= (arr[offset + 0] & 0xFF) << 21;
        rv |= (arr[offset + 1] & 0xFF) << 14;
        rv |= (arr[offset + 2] & 0xFF) << 7;
        if (ByteConverter.getBits(rv |= (arr[offset + 3] & 0xFF) << 0, 4, 5) == 1) {
            rv |= 0xF0000000;
        }
        return rv;
    }

    public static int getBits(int src, int startBit, int endBit) {
        int mask = (int)(Math.pow(2.0, endBit - startBit) - 1.0);
        int rv = (src & (mask <<= 32 - endBit)) >> 32 - endBit;
        return rv;
    }

    private ByteConverter() {
    }
}

