/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.research.trap.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ChildFirstURLClassLoader
extends URLClassLoader {
    public ChildFirstURLClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    protected boolean shouldLoadChildFirst(String name) {
        return true;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (!this.shouldLoadChildFirst(name)) {
            return super.loadClass(name, resolve);
        }
        try {
            Class<?> findClass;
            ChildFirstURLClassLoader current = this;
            ClassLoader parent = this;
            Method m = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
            m.setAccessible(true);
            do {
                if ((findClass = (Class<?>)m.invoke((Object)(current = parent), name)) == null) continue;
                return findClass;
            } while ((parent = this.getParent()) != null && parent != current);
            findClass = this.loadClassFromBytes(name);
            if (resolve) {
                this.resolveClass(findClass);
            }
            return findClass;
        }
        catch (Throwable e) {
            return super.loadClass(name, resolve);
        }
    }

    Class<?> loadClassFromBytes(String name) throws ClassNotFoundException {
        String resName = name.replace('.', '/') + ".class";
        InputStream resStream = this.getResourceAsStream(resName);
        ChildFirstURLClassLoader current = this;
        ClassLoader parent = this;
        do {
            current = parent;
            resStream = ((ClassLoader)current).getResourceAsStream(resName);
            parent = this.getParent();
        } while (resStream == null && parent != null && current != parent);
        if (resStream == null) {
            resStream = ClassLoader.getSystemResourceAsStream(resName);
        }
        try {
            int read;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(resStream.available());
            byte[] buf = new byte[4096];
            while ((read = resStream.read(buf)) > -1) {
                bos.write(buf, 0, read);
            }
            resStream.close();
            buf = bos.toByteArray();
            Class<?> defined = this.defineClass(name, buf, 0, buf.length);
            return defined;
        }
        catch (IOException e) {
            return this.findClass(name);
        }
    }
}

