/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.research.trap.utils;

import com.ericsson.research.trap.utils.ConditionalBlock;
import java.util.Arrays;

class ConditionalBlockImpl
extends ConditionalBlock {
    private final String name;
    private long timeout = 10000L;
    private boolean unlocked;
    private byte[] condition;

    public ConditionalBlockImpl(String name) {
        this.name = name;
    }

    public ConditionalBlockImpl(String name, long timeout) {
        this(name);
        this.timeout = timeout;
    }

    public synchronized void block(byte[] condition) {
        if (this.condition == null) {
            this.condition = condition;
        } else if (!Arrays.equals(condition, this.condition)) {
            throw new IllegalArgumentException("Tried to lock a blocked block with a different condition. Bad idea.");
        }
        if (this.unlocked) {
            return;
        }
        try {
            long startTime = System.currentTimeMillis();
            long endTime = startTime + this.timeout;
            while (!this.unlocked) {
                long waitTime = endTime - System.currentTimeMillis();
                if (waitTime <= 0L) {
                    throw new RuntimeException("Timeout during " + this.name);
                }
                this.wait(waitTime);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.unlocked) {
            throw new RuntimeException("Timeout during " + this.name);
        }
    }

    public synchronized boolean unblock(byte[] condition) {
        if (!Arrays.equals(condition, this.condition)) {
            return false;
        }
        this.doUnblock();
        return true;
    }

    public synchronized void reset() {
        this.doUnblock();
        this.unlocked = false;
    }

    private synchronized void doUnblock() {
        this.unlocked = true;
        this.notifyAll();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public static ConditionalBlockImpl create(String string) {
        return new ConditionalBlockImpl(string);
    }

    public synchronized void setCondition(byte[] condition) {
        this.condition = condition;
    }
}

