/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.research.trap.utils;

import com.ericsson.research.trap.utils.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class HexDump {
    public static void main(String[] args) throws IOException {
        byte[] bytes = StringUtil.toUtfBytes("This is an example of hex dumping some bytes...");
        for (int index = 0; index < bytes.length; index += 20) {
            HexDump.printHex(bytes, index, 20, System.out);
            HexDump.printAscii(bytes, index, 20, System.out);
        }
    }

    public static Object makeStringifyable(final byte[] bytes, final int start, final int width) {
        return new Object(){
            String str = null;

            public String toString() {
                if (this.str == null) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    try {
                        PrintStream ps = new PrintStream((OutputStream)bos, true, "UTF-8");
                        HexDump.printBytes(bytes, start, width, ps);
                        this.str = bos.toString("UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                        this.str = "Unsupported Encoding";
                    }
                }
                return this.str;
            }
        };
    }

    public static void printBytes(byte[] bytes, int start, int width) {
        HexDump.printBytes(bytes, start, width, System.out);
    }

    public static void printBytes(byte[] bytes, int start, int width, PrintStream ps) {
        for (int index = 0; index < bytes.length; index += width) {
            HexDump.printHex(bytes, index, width, ps);
            try {
                HexDump.printAscii(bytes, index, width, ps);
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    private static void printHex(byte[] bytes, int offset, int width, PrintStream os) {
        for (int index = 0; index < width; ++index) {
            if (index + offset < bytes.length) {
                os.printf("%02x ", bytes[index + offset]);
                continue;
            }
            os.print("   ");
        }
    }

    private static void printAscii(byte[] bytes, int index, int width, PrintStream ps) throws UnsupportedEncodingException {
        if (index < bytes.length) {
            width = Math.min(width, bytes.length - index);
            ps.println(new String(bytes, index, width, "US-ASCII").replaceAll("[^\\x21-\\x7E]", "."));
        } else {
            ps.println();
        }
    }

    private HexDump() {
    }
}

