/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.research.trap.utils;

import com.ericsson.research.trap.utils.IPUtil;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

class IPUtilImpl
extends IPUtil {
    IPUtilImpl() {
    }

    int score(String ifaceName) {
        if (ifaceName.startsWith("en")) {
            return 1;
        }
        if (ifaceName.startsWith("eth")) {
            return 2;
        }
        if (ifaceName.startsWith("ethernet")) {
            return 3;
        }
        if (ifaceName.startsWith("wireless")) {
            return 4;
        }
        if (ifaceName.startsWith("wi")) {
            return 5;
        }
        return 6;
    }

    InetAddress[] performGetPublicAddresses() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            HashMap ifaceAddresses = new HashMap();
            LinkedList<String> ifaceNames = new LinkedList<String>();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface iface = networkInterfaces.nextElement();
                HashSet<InetAddress> foundAddresses = new HashSet<InetAddress>();
                Enumeration<InetAddress> inetAddresses = iface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress address = inetAddresses.nextElement();
                    if (IPUtil.isLocal(address)) continue;
                    foundAddresses.add(address);
                }
                ifaceAddresses.put(iface.getName(), foundAddresses);
                ifaceNames.add(iface.getName());
            }
            Collections.sort(ifaceNames, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return IPUtilImpl.this.score(o1) - IPUtilImpl.this.score(o2);
                }
            });
            LinkedList foundAddresses = new LinkedList();
            for (String name : ifaceNames) {
                foundAddresses.addAll((Collection)ifaceAddresses.get(name));
            }
            return foundAddresses.toArray(new InetAddress[0]);
        }
        catch (SocketException e) {
            return new InetAddress[0];
        }
    }

    String performGetAddressForURI(InetAddress address) {
        boolean isv6;
        String host = address.getHostAddress();
        byte[] bs = address.getAddress();
        boolean bl = isv6 = bs.length > 4;
        if (isv6) {
            host = "[" + host + "]";
        }
        return host;
    }

    boolean performIsLocal(InetAddress address) {
        boolean disqualified = false;
        if (address instanceof Inet6Address) {
            byte[] addr = address.getAddress();
            if (addr[0] == -2 && (addr[1] & 0xC) != 0) {
                disqualified = true;
            }
            if (addr[0] == -4 || addr[0] == -3) {
                disqualified = true;
            }
        }
        return disqualified || address.isMulticastAddress() || address.isAnyLocalAddress() || address.isLoopbackAddress() || address.isLinkLocalAddress() || address.isSiteLocalAddress();
    }
}

