/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.research.trap.utils;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUCache<K, V> {
    ConcurrentHashMap<K, V> cache = new ConcurrentHashMap();
    ConcurrentLinkedQueue<K> strongRefs = new ConcurrentLinkedQueue();
    private AtomicLong numRefs = new AtomicLong();
    private long maxCacheSize = 25L;
    AtomicLong numHits = new AtomicLong(0L);
    AtomicLong numQueries = new AtomicLong(1L);
    long f = 0L;

    protected LRUCache(long size) {
        this.maxCacheSize = size;
    }

    public static <K, V> LRUCache<K, V> createCache() {
        return new LRUCache<K, V>(25L);
    }

    public static <K, V> LRUCache<K, V> createCache(long size) {
        return new LRUCache<K, V>(size);
    }

    public void put(K key, V value) {
        this.cache.put(key, value);
        this.strongRefs.add(key);
        long val = this.numRefs.incrementAndGet();
        while (val > this.maxCacheSize && this.numRefs.compareAndSet(val, val - 1L)) {
            K k1 = this.strongRefs.poll();
            this.cache.remove(k1);
            val = this.numRefs.get();
        }
    }

    public V get(K key) {
        this.numQueries.incrementAndGet();
        return this.cache.get(key);
    }

    public V get(K key, LRUDefault<V> defaultValue) {
        this.numQueries.incrementAndGet();
        V v = this.cache.get(key);
        if (v == null) {
            v = defaultValue.get();
            this.cache.put(key, v);
            this.strongRefs.add(key);
            long val = this.numRefs.incrementAndGet();
            while (val > this.maxCacheSize && this.numRefs.compareAndSet(val, val - 1L)) {
                K k1 = this.strongRefs.poll();
                this.cache.remove(k1);
                val = this.numRefs.get();
            }
        } else {
            this.numHits.incrementAndGet();
        }
        return v;
    }

    public String toString() {
        return "Cache: " + this.numRefs + ", " + this.numHits.get() * 100L / this.numQueries.get() + "%";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface LRUDefault<V> {
        public V get();
    }
}

