/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.research.trap.utils;

import com.ericsson.research.trap.utils.PackageScannerNull;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PackageScanner {
    private static PackageScanner instance;
    static WeakHashMap<ClassLoader, HashMap<String, Class<?>[]>> cache;

    public static Class<?>[] scan(String packageName) throws IOException {
        return instance.performScan(packageName, ClassLoader.getSystemClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?>[] scan(String packageName, ClassLoader cl) throws IOException {
        Class[] rv;
        HashMap<String, Object> clCache;
        AbstractMap abstractMap = cache;
        synchronized (abstractMap) {
            clCache = cache.get(cl);
            if (clCache == null) {
                clCache = new HashMap();
                cache.put(cl, clCache);
            }
        }
        abstractMap = clCache;
        synchronized (abstractMap) {
            rv = (Class[])clCache.get(packageName);
        }
        if (rv == null) {
            rv = instance.performScan(packageName, cl);
            Arrays.sort(rv, new Comparator<Class<?>>(){

                @Override
                public int compare(Class<?> o1, Class<?> o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            clCache.put(packageName, rv);
        }
        return rv;
    }

    abstract Class<?>[] performScan(String var1, ClassLoader var2) throws IOException;

    PackageScanner() {
    }

    static {
        String[] scanners = new String[]{"com.ericsson.research.trap.utils.JBossVFSPackageScanner", "com.ericsson.research.trap.utils.AndroidPackageScanner", PackageScanner.class.getName() + "Impl", PackageScanner.class.getName() + "File", PackageScanner.class.getName() + "Null"};
        for (int i = 0; i < scanners.length; ++i) {
            try {
                Class<?> c = Class.forName(scanners[i]);
                instance = (PackageScanner)c.newInstance();
                Class<?>[] arr = instance.performScan(instance.getClass().getPackage().getName(), instance.getClass().getClassLoader());
                boolean found = false;
                for (Class<?> c1 : arr) {
                    if (!instance.getClass().equals(c1)) continue;
                    found = true;
                    break;
                }
                if (found || instance instanceof PackageScannerNull) break;
                instance = null;
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (instance == null) {
            System.err.println("WARNING: Could not initialise PackageScanner. Either no package scanners were found, or none of the scanners could pass the initial test. Bad Things(tm) can happen in this environment. Please ensure anything that scans for classes does not need to do so (or fix the scanner for this environment)");
        }
        cache = new WeakHashMap();
    }
}

