/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.research.trap.utils;

import com.ericsson.research.trap.utils.PackageScanner;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PackageScannerFile
extends PackageScanner {
    HashSet<String> classNames = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageScannerFile() throws IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("trap-packages.txt");
        InputStreamReader isr = null;
        BufferedReader br = null;
        if (is == null) {
            throw new InstantiationError("No packages index file included in the classpath");
        }
        try {
            String line;
            isr = new InputStreamReader(is, Charset.forName("UTF-8"));
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                this.classNames.add(line);
            }
        }
        finally {
            is.close();
            if (br != null) {
                br.close();
            }
            if (isr != null) {
                isr.close();
            }
        }
    }

    @Override
    Class<?>[] performScan(String packageName, ClassLoader c) throws IOException {
        ArrayList rv = new ArrayList();
        for (String name : this.classNames) {
            try {
                Class<?> cs = c.loadClass(name);
                rv.add(cs);
            }
            catch (Throwable throwable) {}
        }
        return rv.toArray(new Class[0]);
    }
}

