/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.research.trap.utils;

import com.ericsson.research.trap.utils.LRUCache;
import com.ericsson.research.trap.utils.PackageScanner;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PackageScannerImpl
extends PackageScanner {
    LRUCache<CacheKey, Class<?>[]> cache = LRUCache.createCache();

    PackageScannerImpl() {
    }

    @Override
    public Class<?>[] performScan(String packageName, ClassLoader c) throws IOException {
        CacheKey key = new CacheKey(packageName, c);
        Class<?>[] value = this.cache.get(key);
        if (value != null) {
            return value;
        }
        HashSet classes = new HashSet();
        String relPath = packageName.replace('.', '/');
        Enumeration<URL> resources = c.getResources(relPath);
        while (resources.hasMoreElements()) {
            this.scanPackage(classes, resources.nextElement(), packageName);
        }
        value = classes.toArray(new Class[0]);
        this.cache.put(key, value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanPackage(HashSet<Class<?>> outSet, URL packageUrl, String packageName) throws MalformedURLException {
        File directory;
        String packagePath = packageName.replace('.', '/');
        String path = packageUrl.getFile();
        try {
            try {
                directory = new File(new URI(packageUrl.toString()));
            }
            catch (URISyntaxException e) {
                directory = new File(packageUrl.getPath());
            }
            catch (IllegalArgumentException e) {
                directory = new File(URLDecoder.decode(packageUrl.getFile(), "UTF-8"));
            }
        }
        catch (IllegalArgumentException e) {
            directory = null;
        }
        catch (UnsupportedEncodingException e) {
            directory = null;
        }
        if (directory != null && directory.exists()) {
            String[] files = directory.list();
            if (files == null) {
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                if (files[i].endsWith(".class")) {
                    String className = packageName + '.' + files[i].substring(0, files[i].length() - 6);
                    try {
                        outSet.add(Class.forName(className));
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                this.scanPackage(outSet, new URL(directory.toURI().toURL().toString() + "/" + files[i]), packageName + "." + files[i]);
            }
        } else {
            try {
                String jarPath = path.replaceFirst("[.]jar[!].*", ".jar").replaceFirst("file:", "");
                jarPath = jarPath.replaceAll("%20", " ");
                JarFile jarFile = new JarFile(jarPath);
                try {
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String entryName = entry.getName();
                        if (entryName.endsWith("/") || !entryName.startsWith(packagePath) || entryName.length() <= packagePath.length() + "/".length()) continue;
                        String className = entryName.replace('/', '.').replace('\\', '.');
                        if (className.endsWith(".class")) {
                            className = className.substring(0, className.length() - 6);
                        }
                        try {
                            outSet.add(Class.forName(className));
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                        }
                        catch (NoClassDefFoundError noClassDefFoundError) {}
                    }
                }
                finally {
                    jarFile.close();
                }
            }
            catch (IOException e) {
                System.err.println(packageName + " (" + directory + ") does not appear to be a valid package");
            }
        }
    }

    static class CacheKey {
        private int code;

        public CacheKey(String packageName, ClassLoader c) {
            this.code = packageName.hashCode() + c.hashCode();
        }

        public int hashCode() {
            return this.code;
        }

        public boolean equals(Object other) {
            return other instanceof CacheKey && other.hashCode() == this.code;
        }
    }
}

