/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.research.trap.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SSLUtil {
    private static final Map<SSLMaterial, KeyManagerFactory> keyManagerFactories = new Hashtable<SSLMaterial, KeyManagerFactory>();
    private static final Map<SSLMaterial, TrustManagerFactory> trustManagerFactories = new Hashtable<SSLMaterial, TrustManagerFactory>();

    public static KeyManagerFactory getKeyManagerFactory(SSLMaterial keyStore) throws NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException, KeyStoreException {
        KeyStore ksKeys = KeyStore.getInstance(keyStore.getKeyMaterialType());
        ksKeys.load(keyStore.getKeyMaterialInputStream(), keyStore.getKeyMaterialPassphrase());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(ksKeys, keyStore.getKeyMaterialPassphrase());
        return kmf;
    }

    public static TrustManagerFactory getTrustManagerFactory(SSLMaterial trustStore) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        if (trustStore != null) {
            KeyStore ksTrust = KeyStore.getInstance(trustStore.getKeyMaterialType());
            ksTrust.load(trustStore.getKeyMaterialInputStream(), trustStore.getKeyMaterialPassphrase());
            tmf.init(ksTrust);
        } else {
            tmf.init((KeyStore)null);
        }
        return tmf;
    }

    public static SSLContext getContext(SSLMaterial keyStore, SSLMaterial trustStore) {
        SSLContext sslc;
        KeyManagerFactory kmf = keyManagerFactories.get(keyStore);
        TrustManagerFactory tmf = trustManagerFactories.get(trustStore);
        try {
            if (kmf == null) {
                kmf = SSLUtil.getKeyManagerFactory(keyStore);
                keyManagerFactories.put(keyStore, kmf);
            }
            if (tmf == null) {
                tmf = SSLUtil.getTrustManagerFactory(trustStore);
                trustManagerFactories.put(trustStore, tmf);
            }
            sslc = SSLContext.getInstance("TLS");
            sslc.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize SSL context", e);
        }
        return sslc;
    }

    public static void purgeKeyStore(SSLMaterial keyStore) {
        keyManagerFactories.remove(keyStore);
    }

    public static void purgeTrustStore(SSLMaterial trustStore) {
        trustManagerFactories.remove(trustStore);
    }

    public static SSLContext getInsecure() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslc = SSLContext.getInstance("TLS");
        sslc.init(null, new TrustManager[]{new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }}, null);
        return sslc;
    }

    public static class SSLMaterial {
        private String keyMaterialType;
        private String keyMaterialFilename;
        private String keyMaterialPassphrase;
        public static final String PKCS12_TYPE = "pkcs12";
        public static final String JKS_TYPE = "jks";

        public SSLMaterial() {
        }

        public SSLMaterial(String keyMaterialType, String keyMaterialFilename, String keyMaterialPassphrase) {
            this.setKeyMaterialType(keyMaterialType);
            this.setKeyMaterialFilename(keyMaterialFilename);
            this.setKeyMaterialPassphrase(keyMaterialPassphrase);
        }

        public String getKeyMaterialType() {
            return this.keyMaterialType;
        }

        public void setKeyMaterialType(String keyMaterialType) {
            this.keyMaterialType = keyMaterialType != null ? keyMaterialType : JKS_TYPE;
        }

        public InputStream getKeyMaterialInputStream() {
            InputStream rv = null;
            if (this.keyMaterialFilename != null) {
                try {
                    rv = new FileInputStream(this.keyMaterialFilename);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (rv == null) {
                rv = this.getClass().getClassLoader().getResourceAsStream(this.keyMaterialFilename);
            }
            return rv;
        }

        public void setKeyMaterialFilename(String keyMaterialFilename) {
            this.keyMaterialFilename = keyMaterialFilename;
        }

        public char[] getKeyMaterialPassphrase() {
            return this.keyMaterialPassphrase.toCharArray();
        }

        public void setKeyMaterialPassphrase(String keyMaterialPassphrase) {
            this.keyMaterialPassphrase = keyMaterialPassphrase;
        }

        public int hashCode() {
            return this.keyMaterialType.hashCode() + this.keyMaterialFilename.hashCode() + this.keyMaterialPassphrase.hashCode();
        }
    }
}

