/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.research.trap.utils;

import com.ericsson.research.trap.utils.Future;

public abstract class ThreadPool {
    private static ThreadPool instance;

    public static Future executeAfter(Runnable task, long delay) {
        return instance.performSchedule(task, delay);
    }

    abstract Future performSchedule(Runnable var1, long var2);

    public static Future weakExecuteAfter(Runnable task, long delay) {
        return instance.performWeakExecuteAfter(task, delay);
    }

    abstract Future performWeakExecuteAfter(Runnable var1, long var2);

    public static Future executeAt(Runnable task, long timestamp) {
        long delay = timestamp - System.currentTimeMillis();
        if (delay < 0L) {
            delay = 0L;
        }
        return ThreadPool.executeAfter(task, delay);
    }

    public static void executeFixed(Runnable task) {
        instance.performExecuteFixed(task);
    }

    abstract void performExecuteFixed(Runnable var1);

    public static void executeCached(Runnable task) {
        instance.performExecuteCached(task);
    }

    abstract void performExecuteCached(Runnable var1);

    ThreadPool() {
    }

    static {
        try {
            Class<?> c = Class.forName(ThreadPool.class.getName() + "Impl");
            instance = (ThreadPool)c.newInstance();
        }
        catch (Throwable t) {
            System.err.println("Could not initialise ThreadPool Impl");
        }
    }
}

