/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.research.trap.utils.spi;

import com.ericsson.research.trap.utils.Configuration;
import com.ericsson.research.trap.utils.StringUtil;
import com.ericsson.research.trap.utils.spi.PuttableGettableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationImpl
implements Configuration {
    public static final String CONFIG_HASH_PROPERTY = "trap.confighash";
    protected Map<String, String> config = Collections.synchronizedMap(new HashMap());

    public ConfigurationImpl() {
    }

    public ConfigurationImpl(String config) {
        if (config != null) {
            this.initFromString(config);
        }
    }

    public ConfigurationImpl(Configuration config) {
        this.config = ((ConfigurationImpl)config).config;
    }

    public ConfigurationImpl(Map<String, String> config) {
        this.config = config;
    }

    @Override
    public void initFromString(String config) {
        if (config == null) {
            return;
        }
        String[] strings = StringUtil.split(config, '\n');
        String prefix = "";
        for (int i = 0; i < strings.length; ++i) {
            String c = strings[i].trim();
            int pos = c.indexOf(61);
            if (pos < 0 || pos >= c.length() - 1) {
                if (!c.endsWith(".")) continue;
                prefix = c.substring(0, c.length() - 1);
                continue;
            }
            String key = c.substring(0, pos).trim();
            String val = c.substring(pos + 1).trim().replaceAll("\\\\n", "\n");
            if (key.startsWith(".")) {
                key = prefix + key;
            } else {
                prefix = "";
            }
            this.setOption(key, val);
        }
    }

    @Override
    public Map<String, String> getOptions(String optionsPrefix) {
        return this.getOptions(optionsPrefix, true);
    }

    @Override
    public Map<String, String> getOptions(String optionsPrefix, boolean cutPrefixes) {
        PuttableGettableMap m = new PuttableGettableMap(this, optionsPrefix, cutPrefixes);
        return m;
    }

    @Override
    public Configuration getChildOptions(String optionsPrefix, boolean cutPrefixes, boolean updateParent) {
        if (updateParent) {
            return new ConfigurationImpl(new PuttableGettableMap(this, optionsPrefix, cutPrefixes));
        }
        int x = cutPrefixes && !optionsPrefix.endsWith(".") ? 1 : 0;
        ConfigurationImpl c = new ConfigurationImpl();
        for (String key : this.getKeys()) {
            String value = this.getOption(key);
            if (!key.startsWith(optionsPrefix)) continue;
            if (cutPrefixes) {
                key = key.substring(optionsPrefix.length() + x);
            }
            c.setOption(key, value);
        }
        return c;
    }

    @Override
    public String getOption(String option) {
        return this.config.get(option);
    }

    @Override
    public String getOption(String prefix, String option) {
        return this.getOption(prefix + "." + option);
    }

    @Override
    public void setOption(String option, String value) {
        if (value == null) {
            this.config.remove(option);
        } else {
            this.config.put(option, value);
        }
    }

    @Override
    public void setOption(String prefix, String option, String value) {
        this.setOption(prefix + "." + option, value);
    }

    @Override
    public int getIntOption(String option, int defaultValue) {
        try {
            String strValue = this.getOption(option);
            if (strValue != null) {
                return Integer.parseInt(strValue);
            }
            return defaultValue;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        Object[] keys = this.getKeys().toArray();
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            sb.append(keys[i]);
            sb.append(" = ");
            String oval = this.getOption((String)keys[i]);
            if (oval != null) {
                sb.append(oval.replaceAll("\n", "\\\\n"));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public void setConfig(HashMap<String, String> config) {
        this.config = config;
    }

    @Override
    public boolean getBooleanOption(String key, boolean defaultValue) {
        try {
            String option = this.getOption(key);
            if (option == null) {
                return defaultValue;
            }
            return Boolean.valueOf(option);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public String getStringOption(String key, String defaultValue) {
        String rv = this.getOption(key);
        if (rv != null) {
            return rv;
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getKeys() {
        Map<String, String> map = this.config;
        synchronized (map) {
            return new TreeSet<String>(this.config.keySet());
        }
    }

    @Override
    public Set<String> getKeys(int keyDepth) {
        HashSet<String> keys = new HashSet<String>();
        Set<String> fullKeys = this.getKeys();
        for (String key : fullKeys) {
            int idx = 0;
            for (int i = 0; i < keyDepth && i >= 0; ++i) {
                idx = key.indexOf(46, idx);
            }
            if (idx <= 0) {
                keys.add(key);
                continue;
            }
            keys.add(key.substring(0, idx));
        }
        return keys;
    }

    protected Map<String, String> createPuttableGettableMap(String optionsPrefix, boolean cutPrefixes) {
        return new PuttableGettableMap(this, optionsPrefix, cutPrefixes);
    }

    @Override
    public long getLongOption(String option, long defaultValue) {
        try {
            return Long.parseLong(this.getOption(option));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public double getDoubleOption(String option, double defaultValue) {
        try {
            return Double.parseDouble(this.getOption(option));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }
}

