/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.research.trap.utils.spi;

import com.ericsson.research.trap.utils.Configuration;
import com.ericsson.research.trap.utils.spi.MEntry;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PuttableGettableMap
implements Map<String, String> {
    private final String prefix;
    private final boolean cutPrefixes;
    private final Configuration parent;

    public PuttableGettableMap(Configuration parent, String prefix, boolean cutPrefixes) {
        this.parent = parent;
        this.prefix = prefix;
        this.cutPrefixes = cutPrefixes;
    }

    private String prefixKey(Object key) {
        StringBuffer sb = new StringBuffer(this.cutPrefixes ? this.prefix : key.toString());
        if (this.cutPrefixes) {
            if (!this.prefix.endsWith(".")) {
                sb.append(".");
            }
            sb.append(key.toString());
        }
        return sb.toString();
    }

    @Override
    public String put(String key, String value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException();
        }
        this.parent.setOption(this.prefixKey(key), value.toString());
        return value;
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        for (Map.Entry<? extends String, ? extends String> e : m.entrySet()) {
            this.put(e.getKey().toString(), e.getValue().toString());
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keySet().contains(key);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        TreeSet<Map.Entry<String, String>> rv = new TreeSet<Map.Entry<String, String>>();
        Set<String> s = this.keySet();
        for (String key : s) {
            rv.add(new MEntry<String, String>(this, key, this.get(key)));
        }
        return rv;
    }

    @Override
    public String get(Object key) {
        if (!this.keySet().contains(key)) {
            return null;
        }
        return this.parent.getOption(this.prefixKey(key));
    }

    @Override
    public boolean isEmpty() {
        return this.keySet().size() == 0;
    }

    @Override
    public Set<String> keySet() {
        int x;
        Set<String> s = this.parent.getKeys();
        TreeSet<String> keySet = new TreeSet<String>();
        Iterator<String> it = s.iterator();
        int n = x = this.cutPrefixes && !this.prefix.endsWith(".") ? 1 : 0;
        while (it.hasNext()) {
            String key = it.next();
            if (!key.startsWith(this.prefix)) continue;
            if (this.cutPrefixes) {
                key = key.substring(this.prefix.length() + x);
            }
            keySet.add(key);
        }
        return keySet;
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public Collection<String> values() {
        LinkedList<String> l = new LinkedList<String>();
        Set<String> s = this.keySet();
        for (String key : s) {
            l.add(this.get(key));
        }
        return l;
    }

    @Override
    public void clear() {
        throw new IllegalAccessError("Cannot clear using a PGM");
    }

    @Override
    public boolean containsValue(Object arg0) {
        throw new IllegalAccessError("Cannot check for values using a PGM");
    }

    @Override
    public String remove(Object arg0) {
        throw new IllegalAccessError("Cannot remove using a PGM");
    }
}

