/*
 * Decompiled with CFR 0.152.
 */
package com.dsk.acc.openapi.client.core;

import com.dsk.acc.openapi.client.exception.AccException;
import com.dsk.acc.openapi.client.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.Response;

public class AccResponse {
    public Response response;
    public int statusCode;
    public String statusMessage;
    public HashMap<String, String> headers = new HashMap();
    public InputStream body;

    public AccResponse() {
    }

    public AccResponse(Response response) {
        this.response = response;
        this.statusCode = response.code();
        this.statusMessage = response.message();
        this.body = response.body().byteStream();
        Headers headers = response.headers();
        Map resultHeaders = headers.toMultimap();
        for (Map.Entry entry : resultHeaders.entrySet()) {
            this.headers.put((String)entry.getKey(), StringUtils.join(";", (Iterable)entry.getValue()));
        }
    }

    public InputStream getResponse() {
        return this.body;
    }

    public String getResponseBody() {
        if (null == this.body) {
            return String.format("{\"message\":\"%s\"}", this.statusMessage);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buff = new byte[4096];
        try {
            int read;
            while ((read = this.body.read(buff)) != -1) {
                os.write(buff, 0, read);
            }
        }
        catch (Exception e) {
            throw new AccException(e.getMessage(), e);
        }
        return new String(os.toByteArray());
    }
}

