/*
 * Decompiled with CFR 0.152.
 */
package com.github.apiggs.ast;

import com.github.apiggs.ast.Annotations;
import com.github.apiggs.ast.Comments;
import com.github.apiggs.ast.Expressions;
import com.github.apiggs.schema.Appendix;
import com.github.apiggs.util.Cell;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserFieldDeclaration;
import java.util.Optional;

public class Fields {
    public static final String ANNOTATION_ALIAS_JACKSON = "JsonProperty";
    public static final String ANNOTATION_ALIAS_GSON = "SerializedName";
    public static final String ANNOTATION_ALIAS_FASTJSON = "JSONField";

    public static Object getInitializer(JavaParserFieldDeclaration field) {
        Optional initializer = field.getVariableDeclarator().getInitializer();
        if (initializer.isPresent()) {
            Expression expr = (Expression)initializer.get();
            return Expressions.getValue(expr);
        }
        return null;
    }

    public static String getName(ResolvedFieldDeclaration n) {
        if (n instanceof JavaParserFieldDeclaration) {
            Object value;
            JavaParserFieldDeclaration field = (JavaParserFieldDeclaration)n;
            FieldDeclaration declaration = field.getWrappedNode();
            if (declaration.getAnnotationByName(ANNOTATION_ALIAS_JACKSON).isPresent() && (value = Annotations.getAttr(declaration.getAnnotationByName(ANNOTATION_ALIAS_JACKSON), "value")) != null) {
                return String.valueOf(value);
            }
            if (declaration.getAnnotationByName(ANNOTATION_ALIAS_GSON).isPresent() && (value = Annotations.getAttr(declaration.getAnnotationByName(ANNOTATION_ALIAS_GSON), "value")) != null) {
                return String.valueOf(value);
            }
            if (declaration.getAnnotationByName(ANNOTATION_ALIAS_FASTJSON).isPresent() && (value = Annotations.getAttr(declaration.getAnnotationByName(ANNOTATION_ALIAS_FASTJSON), "name")) != null) {
                return String.valueOf(value);
            }
        }
        return n.getName();
    }

    public static Appendix getConstants(ClassOrInterfaceDeclaration declaration) {
        Appendix appendix = new Appendix();
        appendix.setName(declaration.getNameAsString());
        appendix.accept(declaration.getComment());
        for (FieldDeclaration field : declaration.getFields()) {
            Optional<Comments> optional;
            if (!field.isStatic() || !field.isPublic() || !field.isFinal()) continue;
            VariableDeclarator variable = field.getVariable(0);
            String value = null;
            String description = null;
            if (variable.getInitializer().isPresent()) {
                value = String.valueOf(Expressions.getValue((Expression)variable.getInitializer().get()));
            }
            if ((optional = Comments.of(field.getComment())).isPresent()) {
                description = optional.get().content;
            }
            appendix.getCells().add(new Cell<String>(variable.getNameAsString(), value, description));
        }
        return appendix;
    }
}

