/*
 * Decompiled with CFR 0.152.
 */
package com.github.apiggs.ast;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;

public class Types {
    public static String getFullName(ClassOrInterfaceDeclaration n) {
        return Types.getPackageName(n) + "." + Types.getNameInScope(n);
    }

    public static String getPackageName(ClassOrInterfaceDeclaration n) {
        if (n.getParentNode().isPresent()) {
            CompilationUnit cu;
            if (n.getParentNode().get() instanceof CompilationUnit && (cu = (CompilationUnit)n.getParentNode().get()).getPackageDeclaration().isPresent()) {
                PackageDeclaration packageDeclaration = (PackageDeclaration)cu.getPackageDeclaration().get();
                return packageDeclaration.getNameAsString();
            }
            if (n.getParentNode().get() instanceof ClassOrInterfaceDeclaration) {
                return Types.getPackageName((ClassOrInterfaceDeclaration)n.getParentNode().get());
            }
        }
        return "";
    }

    public static String getNameInScope(ClassOrInterfaceDeclaration n) {
        StringBuilder stringBuilder = new StringBuilder();
        Types.appendNameInScope(n, stringBuilder);
        return stringBuilder.toString();
    }

    private static void appendNameInScope(ClassOrInterfaceDeclaration n, StringBuilder stringBuilder) {
        stringBuilder.insert(0, n.getNameAsString());
        if (n.getParentNode().isPresent() && n.getParentNode().get() instanceof ClassOrInterfaceDeclaration) {
            ClassOrInterfaceDeclaration scope = (ClassOrInterfaceDeclaration)n.getParentNode().get();
            stringBuilder.insert(0, ".");
            Types.appendNameInScope(scope, stringBuilder);
        }
    }

    public static class Numbers {
        public static final Set<String> IDS = Sets.newHashSet((Object[])new String[]{Byte.class.getName(), Short.class.getName(), Integer.class.getName(), Long.class.getName(), Float.class.getName(), Double.class.getName(), BigDecimal.class.getName(), BigInteger.class.getName(), AtomicInteger.class.getName(), Number.class.getName()});

        public static boolean isAssignableBy(ResolvedType resolvedType) {
            if (resolvedType instanceof ReferenceTypeImpl) {
                return IDS.contains(((ReferenceTypeImpl)resolvedType).getId());
            }
            return false;
        }
    }

    public static class Maps {
        public static final Set<String> IDS = Sets.newHashSet((Object[])new String[]{HashMap.class.getName(), LinkedHashMap.class.getName(), TreeMap.class.getName(), Map.class.getName()});

        public static boolean isAssignableBy(ResolvedReferenceTypeDeclaration typeDeclaration) {
            return IDS.contains(typeDeclaration.getId());
        }
    }

    public static class Langs {
        public static boolean isAssignableBy(ResolvedReferenceTypeDeclaration typeDeclaration) {
            String id = typeDeclaration.getId();
            return id.startsWith("java");
        }
    }

    public static class Dates {
        public static final Set<String> IDS = Sets.newHashSet((Object[])new String[]{LocalDateTime.class.getName(), Date.class.getName()});

        public static boolean isAssignableBy(ResolvedReferenceTypeDeclaration typeDeclaration) {
            return IDS.contains(typeDeclaration.getId());
        }
    }

    public static class CharSequences {
        public static final Set<String> IDS = Sets.newHashSet((Object[])new String[]{String.class.getName(), Character.class.getName(), CharSequence.class.getName()});

        public static boolean isAssignableBy(ResolvedType resolvedType) {
            if (resolvedType instanceof ReferenceTypeImpl) {
                return IDS.contains(((ReferenceTypeImpl)resolvedType).getId());
            }
            return false;
        }
    }

    public static class Collections {
        public static final Set<String> IDS = Sets.newHashSet((Object[])new String[]{List.class.getName(), ArrayList.class.getName(), LinkedList.class.getName(), Set.class.getName(), HashSet.class.getName(), TreeSet.class.getName(), Collection.class.getName(), Iterable.class.getName()});

        public static boolean isAssignableBy(ResolvedReferenceTypeDeclaration typeDeclaration) {
            return IDS.contains(typeDeclaration.getId());
        }
    }
}

