/*
 * Decompiled with CFR 0.152.
 */
package com.github.apiggs.handler;

import com.github.apiggs.Environment;
import com.github.apiggs.handler.TreeHandler;
import com.github.apiggs.schema.Tree;
import com.github.apiggs.util.loging.Logger;
import com.github.apiggs.util.loging.LoggerFactory;
import java.util.Objects;
import org.asciidoctor.AsciiDocDirectoryWalker;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.DirectoryWalker;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;

public class HtmlTreeHandler
implements TreeHandler {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void handle(Tree tree, Environment env) {
        AttributesBuilder attributes = AttributesBuilder.attributes();
        attributes.sectionNumbers(true);
        attributes.noFooter(true);
        if (Objects.nonNull(env.getCss())) {
            attributes.linkCss(true);
            attributes.styleSheetName(env.getCss());
        }
        Options options = OptionsBuilder.options().mkDirs(true).toDir(env.getOutPath().toFile()).safe(SafeMode.UNSAFE).attributes(attributes).get();
        Asciidoctor asciidoctor = Asciidoctor.Factory.create();
        asciidoctor.convertDirectory((DirectoryWalker)new AsciiDocDirectoryWalker(env.getOutPath().toString()), options);
        this.log.info("Render {}", env.getOutPath());
    }
}

