/*
 * Decompiled with CFR 0.152.
 */
package com.github.apiggs.handler.postman;

import com.github.apiggs.Environment;
import com.github.apiggs.handler.TreeHandler;
import com.github.apiggs.handler.postman.schema.BodyMode;
import com.github.apiggs.handler.postman.schema.Folder;
import com.github.apiggs.handler.postman.schema.Header;
import com.github.apiggs.handler.postman.schema.Info;
import com.github.apiggs.handler.postman.schema.Item;
import com.github.apiggs.handler.postman.schema.Method;
import com.github.apiggs.handler.postman.schema.Parameter;
import com.github.apiggs.handler.postman.schema.Postman;
import com.github.apiggs.handler.postman.schema.Request;
import com.github.apiggs.handler.postman.schema.Response;
import com.github.apiggs.http.HttpMessage;
import com.github.apiggs.schema.Group;
import com.github.apiggs.schema.Tree;
import com.github.apiggs.util.Cell;
import com.github.apiggs.util.ObjectMappers;
import com.github.apiggs.util.loging.Logger;
import com.github.apiggs.util.loging.LoggerFactory;
import com.google.common.base.Charsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class PostmanTreeHandler
implements TreeHandler {
    Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void handle(Tree tree, Environment env) {
        Postman postman = this.buildPostman(tree);
        Path file = env.getOutPath().resolve(env.getId() + ".json");
        this.write(file, ObjectMappers.toPretty(postman), Charsets.UTF_8, new OpenOption[0]);
        this.log.info("Build {}", file);
    }

    private Postman buildPostman(Tree tree) {
        Postman postman = new Postman();
        Info info = new Info();
        info.set_postman_id(tree.getId());
        info.setName(tree.getName());
        info.setDescription(tree.getDescription());
        postman.setInfo(info);
        for (Group group : tree.getBucket().getGroups()) {
            Folder folder = new Folder();
            folder.setName(group.getName());
            folder.setDescription(group.getDescription());
            for (HttpMessage httpMessage : group.getNodes()) {
                folder.getItem().add(this.buildItem(httpMessage));
            }
            postman.getItem().add(folder);
        }
        return postman;
    }

    private Item buildItem(HttpMessage httpMessage) {
        Item item = new Item();
        item.setName(httpMessage.getName());
        item.setDescription(httpMessage.getDescription());
        Request request = new Request();
        request.setDescription(httpMessage.getDescription());
        request.getUrl().setPath(httpMessage.getRequest().getUris().get(0));
        request.setMethod(Method.of(httpMessage.getRequest().getMethod()));
        httpMessage.getRequest().getHeaders().forEach((key, value) -> request.getHeader().add(new Header((String)key, (String)value)));
        if (Method.GET.equals((Object)request.getMethod())) {
            for (Cell<String> cell : httpMessage.getRequest().getCells()) {
                request.getUrl().getQuery().add(Parameter.of(cell));
            }
        } else if ("application/json".equals(httpMessage.getRequest().getHeaders().getContentType())) {
            request.getBody().setMode(BodyMode.raw);
            request.getBody().setRaw(ObjectMappers.toPretty(httpMessage.getRequest().getBody()));
        } else if ("application/x-www-form-urlencoded".equals(httpMessage.getRequest().getHeaders().getContentType())) {
            request.getBody().setMode(BodyMode.urlencoded);
            for (Cell<String> cell : httpMessage.getRequest().getCells()) {
                request.getBody().getUrlencoded().add(Parameter.of(cell));
            }
        } else if ("multipart/form-data".equals(httpMessage.getRequest().getHeaders().getContentType())) {
            request.getBody().setMode(BodyMode.formdata);
            for (Cell<String> cell : httpMessage.getRequest().getCells()) {
                request.getBody().getFormdata().add(Parameter.of(cell));
            }
        }
        item.setRequest(request);
        Response response = new Response();
        response.setName(httpMessage.getResponse().getStatus().toString());
        response.setOriginalRequest(request);
        httpMessage.getResponse().getHeaders().forEach((key, value) -> response.getHeader().add(new Header((String)key, (String)value)));
        response.setBody(ObjectMappers.toPretty(httpMessage.getResponse().getBody()));
        response.setCode(httpMessage.getResponse().getStatus().code());
        response.setStatus(httpMessage.getResponse().getStatus().reasonPhrase());
        item.getResponse().add(response);
        return item;
    }
}

