/*
 * Decompiled with CFR 0.152.
 */
package com.github.apiggs.http;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.apiggs.http.HttpHeaders;
import com.github.apiggs.http.HttpResponseStatus;
import com.github.apiggs.util.Cell;
import com.github.apiggs.util.ObjectMappers;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class HttpResponse {
    HttpResponseStatus status = HttpResponseStatus.DEFAULT;
    HttpHeaders headers = new HttpHeaders();
    Object body;
    List<Cell<String>> cells = new ArrayList<Cell<String>>();

    public boolean isEmpty() {
        return this.cells.isEmpty() && Objects.isNull(this.body) && this.headers.isEmpty();
    }

    public boolean hasBody() {
        return this.body != null;
    }

    public String bodyString() {
        if (this.getBody() != null && this.getBody() instanceof JsonNode) {
            return ObjectMappers.toPretty(this.getBody());
        }
        return "";
    }

    public void setStatus(HttpResponseStatus status) {
        this.status = status;
    }

    public void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public void setCells(List<Cell<String>> cells) {
        this.cells = cells;
    }

    public HttpResponseStatus getStatus() {
        return this.status;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public Object getBody() {
        return this.body;
    }

    public List<Cell<String>> getCells() {
        return this.cells;
    }
}

