/*
 * Decompiled with CFR 0.152.
 */
package com.github.apiggs.markup.asciidoc;

import com.github.apiggs.markup.MarkupBuilder;
import com.github.apiggs.markup.asciidoc.AsciiDoc;
import com.github.apiggs.util.Assert;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Matcher;

public class AsciiDocBuilder
implements MarkupBuilder {
    public static final int MAX_TITLE = 6;
    private StringBuilder content = new StringBuilder();

    @Override
    public MarkupBuilder header(String text, CharSequence ... attrs) {
        Assert.notBlank(text, "header must not be blank");
        this.content.append(AsciiDoc.HEADER);
        this.content.append(this.nobr(text.trim()));
        this.br();
        for (CharSequence attr : attrs) {
            this.content.append(attr);
            this.br();
        }
        this.br();
        return this;
    }

    @Override
    public MarkupBuilder title(int level, String text) {
        Assert.notBlank(text, "header must not be blank");
        Assert.between(level, 1, 6, "title level can not be " + level);
        this.br();
        this.content.append(Strings.repeat((String)AsciiDoc.TITLE.toString(), (int)(level + 1))).append(AsciiDoc.WHITESPACE).append(this.nobr(text.trim()));
        this.br();
        return this;
    }

    @Override
    public MarkupBuilder text(String text) {
        if (Assert.isBlank(text)) {
            return this;
        }
        this.content.append(text.trim());
        return this;
    }

    @Override
    public MarkupBuilder textLine(String text) {
        if (Assert.isBlank(text)) {
            return this;
        }
        this.text(this.nobr(text));
        this.br();
        return this;
    }

    @Override
    public MarkupBuilder paragraph(String text, CharSequence ... attrs) {
        if (Assert.isBlank(text)) {
            return this;
        }
        this.content.append(AsciiDoc.HARDBREAKS);
        this.br();
        if (attrs.length > 0) {
            this.content.append("[");
            for (CharSequence attr : attrs) {
                this.content.append(attr).append(AsciiDoc.WHITESPACE);
            }
            this.content.append("]");
            this.br();
        }
        this.text(text);
        this.newLine();
        return this;
    }

    @Override
    public MarkupBuilder note(String text) {
        this.paragraph(text, AsciiDoc.NOTE);
        return this;
    }

    @Override
    public MarkupBuilder tip(String text) {
        this.paragraph(text, AsciiDoc.TIP);
        return this;
    }

    @Override
    public MarkupBuilder important(String text) {
        this.paragraph(text, AsciiDoc.IMPORTANT);
        return this;
    }

    @Override
    public MarkupBuilder warning(String text) {
        this.paragraph(text, AsciiDoc.WARNING);
        return this;
    }

    @Override
    public MarkupBuilder caution(String text) {
        this.paragraph(text, AsciiDoc.CAUTION);
        return this;
    }

    @Override
    public MarkupBuilder block(Consumer<MarkupBuilder> consumer, CharSequence flag, CharSequence ... attrs) {
        if (attrs.length > 0) {
            this.content.append("[");
            for (CharSequence attr : attrs) {
                this.content.append(attr).append(" ");
            }
            this.content.append("]");
            this.br();
        }
        this.content.append(flag);
        this.br();
        consumer.accept(this);
        this.br();
        this.content.append(flag);
        this.newLine();
        return this;
    }

    @Override
    public MarkupBuilder listing(Consumer<MarkupBuilder> consumer, CharSequence ... attrs) {
        return this.block(consumer, AsciiDoc.LISTING, attrs);
    }

    @Override
    public MarkupBuilder literal(Consumer<MarkupBuilder> consumer, CharSequence ... attrs) {
        return this.block(consumer, AsciiDoc.LITERAL, attrs);
    }

    @Override
    public MarkupBuilder sidebar(Consumer<MarkupBuilder> consumer, CharSequence ... attrs) {
        return this.block(consumer, AsciiDoc.SIDEBAR, attrs);
    }

    @Override
    public MarkupBuilder comment(Consumer<MarkupBuilder> consumer, CharSequence ... attrs) {
        return this.block(consumer, AsciiDoc.COMMENT, attrs);
    }

    @Override
    public MarkupBuilder passthrough(Consumer<MarkupBuilder> consumer, CharSequence ... attrs) {
        return this.block(consumer, AsciiDoc.PASSTHROUGH, attrs);
    }

    @Override
    public MarkupBuilder quote(Consumer<MarkupBuilder> consumer, CharSequence ... attrs) {
        return this.block(consumer, AsciiDoc.QUOTE, attrs);
    }

    @Override
    public MarkupBuilder example(Consumer<MarkupBuilder> consumer, CharSequence ... attrs) {
        return this.block(consumer, AsciiDoc.EXAMPLE, attrs);
    }

    @Override
    public MarkupBuilder list(String text) {
        return this.list(text, AsciiDoc.LIST_FLAG);
    }

    @Override
    public MarkupBuilder list(String text, CharSequence flag) {
        if (!Assert.isBlank(text)) {
            this.content.append(flag).append(this.nobr(text));
        }
        return this;
    }

    @Override
    public MarkupBuilder url(String text, String url) {
        if (!Assert.isBlank(text) && Assert.isBlank(url)) {
            this.content.append(url).append("[").append(this.nobr(text)).append("]");
            this.br();
        }
        return this;
    }

    @Override
    public MarkupBuilder image(String text, String url) {
        if (!Assert.isBlank(text) && !Assert.isBlank(url)) {
            this.text("image:");
            this.url(text, url);
        }
        return this;
    }

    @Override
    public MarkupBuilder table(List<List<String>> data) {
        return this.table(data, true, false);
    }

    @Override
    public MarkupBuilder table(List<List<String>> data, boolean header, boolean footer) {
        int min = 1;
        if (header) {
            ++min;
        }
        if (footer) {
            ++min;
        }
        if (data.size() < min) {
            return this;
        }
        this.content.append("[options=\"");
        if (header) {
            this.content.append("header");
        }
        if (header && footer) {
            this.content.append(",");
        }
        if (footer) {
            this.content.append("footer");
        }
        this.content.append("\"]");
        this.br();
        this.content.append(AsciiDoc.TABLE);
        this.br();
        for (List<String> rows : data) {
            for (String cell : rows) {
                this.content.append(AsciiDoc.TABLE_CELL);
                this.monospaced(cell.replace(AsciiDoc.TABLE_CELL, "\\" + AsciiDoc.TABLE_CELL), new CharSequence[0]);
            }
            this.br();
        }
        this.content.append(AsciiDoc.TABLE);
        this.newLine();
        return this;
    }

    public MarkupBuilder style(CharSequence flag, String text, CharSequence ... textStyle) {
        if (Assert.isBlank(text)) {
            return this;
        }
        if (Objects.nonNull(textStyle) && textStyle.length > 0) {
            this.content.append("[");
            for (CharSequence style : textStyle) {
                this.content.append(style).append(" ");
            }
            this.content.append("]");
        }
        this.content.append(flag);
        this.text(text);
        this.content.append(flag);
        return this;
    }

    @Override
    public MarkupBuilder emphasized(String text, CharSequence ... textStyle) {
        return this.style(AsciiDoc.EMPHASIZED, text, textStyle);
    }

    @Override
    public MarkupBuilder strong(String text, CharSequence ... textStyle) {
        return this.style(AsciiDoc.STRONG, text, textStyle);
    }

    @Override
    public MarkupBuilder monospaced(String text, CharSequence ... textStyle) {
        return this.style(AsciiDoc.MONOSPACED, text, textStyle);
    }

    @Override
    public MarkupBuilder quoted(String text, CharSequence ... textStyle) {
        return this.style(AsciiDoc.QUOTE, text, textStyle);
    }

    @Override
    public MarkupBuilder doubleQuoted(String text, CharSequence ... textStyle) {
        return this.style(AsciiDoc.DOUBLE_QUOTED, text, textStyle);
    }

    @Override
    public MarkupBuilder unquoted(String text, CharSequence ... textStyle) {
        return this.style(AsciiDoc.UNQUOTED, text, textStyle);
    }

    @Override
    public MarkupBuilder br() {
        this.content.append(AsciiDoc.BR);
        return this;
    }

    @Override
    public MarkupBuilder hbr() {
        this.content.append(AsciiDoc.HBR);
        return this;
    }

    @Override
    public MarkupBuilder newLine() {
        this.content.append(AsciiDoc.NEW_LINE);
        return this;
    }

    @Override
    public MarkupBuilder pageBreak() {
        this.content.append(AsciiDoc.PAGEBREAKS);
        this.br();
        return this;
    }

    @Override
    public String getContent() {
        return this.content.toString();
    }

    @Override
    public void clean() {
        this.content = new StringBuilder();
    }

    String nobr(String content) {
        if (Assert.isBlank(content)) {
            return content;
        }
        return content.replaceAll(AsciiDoc.BR.toString(), Matcher.quoteReplacement(AsciiDoc.WHITESPACE.toString()));
    }
}

