/*
 * Decompiled with CFR 0.152.
 */
package com.github.apiggs.schema;

import com.github.apiggs.Environment;
import com.github.apiggs.ast.Comments;
import com.github.javaparser.ast.comments.Comment;
import com.google.common.base.Strings;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class Node {
    public static Comparator<Node> COMPARATOR = (o1, o2) -> {
        if (o1.index != o2.index) {
            return o1.index - o2.index;
        }
        if (o1.id != null && o2.id != null) {
            return o1.id.compareTo(o2.id);
        }
        if (o1.name != null && o2.name != null) {
            return o1.name.compareTo(o2.name);
        }
        return 0;
    };
    String id;
    String name;
    String description;
    int index = Environment.DEFAULT_NODE_INDEX;
    Map<String, Object> ext = new HashMap<String, Object>();

    public void accept(Optional<Comment> comment) {
        Comments.of(comment).ifPresent(this::accept);
    }

    public void accept(Comments comments) {
        if (!Strings.isNullOrEmpty((String)comments.getName())) {
            this.setName(comments.getName());
        }
        if (!Strings.isNullOrEmpty((String)comments.getDescription())) {
            this.setDescription(comments.getDescription());
        }
        this.setIndex(Comments.getIndex(comments, Environment.DEFAULT_NODE_INDEX));
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getIndex() {
        return this.index;
    }

    public Map<String, Object> getExt() {
        return this.ext;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setExt(Map<String, Object> ext) {
        this.ext = ext;
    }
}

