/*
 * Decompiled with CFR 0.152.
 */
package com.github.apiggs.visitor;

import com.github.apiggs.ast.Comments;
import com.github.apiggs.ast.Enums;
import com.github.apiggs.ast.Fields;
import com.github.apiggs.ast.Tag;
import com.github.apiggs.ast.Tags;
import com.github.apiggs.schema.Appendix;
import com.github.apiggs.schema.Node;
import com.github.apiggs.schema.Tree;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import java.util.Objects;

public abstract class NodeVisitor
extends VoidVisitorAdapter<Node> {
    public void visit(CompilationUnit n, Node arg) {
        n.getTypes().forEach(p -> {
            if (Comments.notIgnore((com.github.javaparser.ast.Node)p)) {
                p.accept((VoidVisitor)this, (Object)arg);
            }
        });
    }

    public void visit(ClassOrInterfaceDeclaration n, Node arg) {
        n.getMembers().forEach(p -> {
            if (Comments.notIgnore((com.github.javaparser.ast.Node)p)) {
                p.accept((VoidVisitor)this, (Object)arg);
            }
        });
        n.getComment().ifPresent(l -> l.accept((VoidVisitor)this, (Object)arg));
    }

    public void visit(JavadocComment n, Node arg) {
        if (arg instanceof Tree) {
            Tree tree = (Tree)arg;
            Comments javadoc = Comments.of((Comment)n);
            for (Tag tag : javadoc.getTags()) {
                Appendix appendix;
                if (Objects.equals(tag.getName(), Tags.readme.name())) {
                    tree.setReadme(tag.getContent());
                }
                if (Objects.equals(tag.getName(), Tags.title.name())) {
                    tree.setName(tag.getContent());
                }
                if (Objects.equals(tag.getName(), Tags.description.name())) {
                    tree.setDescription(tag.getContent());
                }
                if (!Objects.equals(tag.getName(), Tags.code.name()) || (appendix = this.parseCode(n)) == null) continue;
                tree.getAppendices().add(appendix);
            }
        }
        super.visit(n, (Object)arg);
    }

    private Appendix parseCode(JavadocComment n) {
        if (n.getCommentedNode().isPresent()) {
            if (n.getCommentedNode().get() instanceof EnumDeclaration) {
                return Enums.toDetails((EnumDeclaration)n.getCommentedNode().get());
            }
            if (n.getCommentedNode().get() instanceof ClassOrInterfaceDeclaration) {
                return Fields.getConstants((ClassOrInterfaceDeclaration)n.getCommentedNode().get());
            }
        }
        return null;
    }
}

