/*
 * Decompiled with CFR 0.152.
 */
package com.github.apiggs.visitor.springmvc;

import com.github.apiggs.ast.ResolvedTypes;
import com.github.apiggs.ast.Types;
import com.github.apiggs.http.HttpMessage;
import com.github.apiggs.http.HttpRequest;
import com.github.apiggs.http.HttpRequestMethod;
import com.github.apiggs.schema.Bucket;
import com.github.apiggs.schema.Group;
import com.github.apiggs.schema.Node;
import com.github.apiggs.schema.Tree;
import com.github.apiggs.util.URL;
import com.github.apiggs.visitor.NodeVisitor;
import com.github.apiggs.visitor.springmvc.Controllers;
import com.github.apiggs.visitor.springmvc.Parameters;
import com.github.apiggs.visitor.springmvc.RequestMappings;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.type.Type;

public class SpringVisitor
extends NodeVisitor {
    @Override
    public void visit(ClassOrInterfaceDeclaration n, Node arg) {
        if (arg instanceof Tree && Controllers.accept((NodeList<AnnotationExpr>)n.getAnnotations())) {
            Tree tree = (Tree)arg;
            Group group = new Group();
            group.setId(Types.getFullName(n));
            group.setName(Types.getNameInScope(n));
            group.setRest(Controllers.isResponseBody(n));
            group.accept(n.getComment());
            Bucket bucket = tree.getBucket(group.getBucketName());
            group.setParent(bucket);
            bucket.getGroups().add(group);
            RequestMappings.of(n).ifPresent(requestMappings -> {
                group.getExt().put("path", requestMappings.getPath().get(0));
                group.getExt().put("method", requestMappings.getMethod());
            });
            arg = group;
        }
        super.visit(n, arg);
    }

    public void visit(MethodDeclaration n, Node arg) {
        Group group;
        if (arg instanceof Group && RequestMappings.accept((NodeList<AnnotationExpr>)n.getAnnotations()) && ((group = (Group)arg).isRest() || RequestMappings.isRequestBody(n))) {
            HttpMessage message = new HttpMessage();
            message.setId(group.getId() + "." + message.getName());
            message.setName(n.getNameAsString());
            message.setParent(group);
            this.visit(n.getType(), message);
            n.getAnnotations().forEach(p -> this.visit((AnnotationExpr)p, message));
            n.getParameters().forEach(p -> this.visit((Parameter)p, message));
            message.accept(n.getComment());
            message.setIndex(group.getNodes().size());
            group.getNodes().add(message);
        }
        super.visit(n, (Object)arg);
    }

    private void visit(Type type, HttpMessage message) {
        ResolvedTypes astResolvedType = ResolvedTypes.of(type);
        if (astResolvedType.resolved) {
            message.getResponse().setBody(astResolvedType.getValue());
            message.getResponse().getCells().addAll(astResolvedType.cells);
        }
    }

    private void visit(Parameter n, HttpMessage message) {
        Parameters parameters = Parameters.of(n);
        HttpRequest request = message.getRequest();
        request.getCells().addAll(parameters.getCells());
        if (parameters.isFile()) {
            if (HttpRequestMethod.GET.equals(request.getMethod())) {
                request.setMethod(HttpRequestMethod.POST);
            }
            request.getHeaders().setContentType("multipart/form-data");
        } else if (parameters.isHeader()) {
            request.getHeaders().put(parameters.getName(), String.valueOf(parameters.getValue()));
        } else if (parameters.isRequestBody()) {
            if (HttpRequestMethod.GET.equals(request.getMethod())) {
                request.setMethod(HttpRequestMethod.POST);
            }
            request.getHeaders().setContentType("application/json");
            request.setBody(parameters.getValue());
        }
    }

    private void visit(AnnotationExpr n, HttpMessage message) {
        if (!RequestMappings.accept(n)) {
            return;
        }
        Group group = message.getParent();
        RequestMappings requestMappings = RequestMappings.of(n);
        message.getRequest().setMethod(requestMappings.getMethod());
        message.getRequest().checkContentType();
        for (String path : requestMappings.getPath()) {
            message.getRequest().getUris().add(URL.normalize(group.getExt().get("path"), path));
        }
        message.getRequest().getHeaders().add(requestMappings.getHeaders());
    }
}

