/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.result;

import com.github.binarywang.wxpay.bean.result.BaseWxPayResult;
import com.google.common.collect.Lists;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.util.List;
import org.w3c.dom.Document;

@XStreamAlias(value="xml")
public class WxPayOrderQueryResult
extends BaseWxPayResult {
    private static final long serialVersionUID = 8241891654782412789L;
    @XStreamAlias(value="promotion_detail")
    private String promotionDetail;
    @XStreamAlias(value="device_info")
    private String deviceInfo;
    @XStreamAlias(value="openid")
    private String openid;
    @XStreamAlias(value="is_subscribe")
    private String isSubscribe;
    @XStreamAlias(value="sub_openid")
    private String subOpenid;
    @XStreamAlias(value="sub_is_subscribe")
    private String isSubscribeSub;
    @XStreamAlias(value="trade_type")
    private String tradeType;
    @XStreamAlias(value="trade_state")
    private String tradeState;
    @XStreamAlias(value="bank_type")
    private String bankType;
    @XStreamAlias(value="detail")
    private String detail;
    @XStreamAlias(value="total_fee")
    private Integer totalFee;
    @XStreamAlias(value="fee_type")
    private String feeType;
    @XStreamAlias(value="settlement_total_fee")
    private Integer settlementTotalFee;
    @XStreamAlias(value="cash_fee")
    private Integer cashFee;
    @XStreamAlias(value="cash_fee_type")
    private String cashFeeType;
    @XStreamAlias(value="coupon_fee")
    private Integer couponFee;
    @XStreamAlias(value="coupon_count")
    private Integer couponCount;
    private List<Coupon> coupons;
    @XStreamAlias(value="transaction_id")
    private String transactionId;
    @XStreamAlias(value="out_trade_no")
    private String outTradeNo;
    @XStreamAlias(value="attach")
    private String attach;
    @XStreamAlias(value="time_end")
    private String timeEnd;
    @XStreamAlias(value="trade_state_desc")
    private String tradeStateDesc;

    public void composeCoupons() {
        if (this.couponCount != null && this.couponCount > 0) {
            this.coupons = Lists.newArrayList();
            for (int i = 0; i < this.couponCount; ++i) {
                this.coupons.add(new Coupon(this.getXmlValue("xml/coupon_type_" + i), this.getXmlValue("xml/coupon_id_" + i), this.getXmlValueAsInt("xml/coupon_fee_" + i)));
            }
        }
    }

    @Override
    protected void loadXML(Document d) {
        this.promotionDetail = WxPayOrderQueryResult.readXMLString(d, "promotion_detail");
        this.deviceInfo = WxPayOrderQueryResult.readXMLString(d, "device_info");
        this.openid = WxPayOrderQueryResult.readXMLString(d, "openid");
        this.isSubscribe = WxPayOrderQueryResult.readXMLString(d, "is_subscribe");
        this.tradeType = WxPayOrderQueryResult.readXMLString(d, "trade_type");
        this.tradeState = WxPayOrderQueryResult.readXMLString(d, "trade_state");
        this.bankType = WxPayOrderQueryResult.readXMLString(d, "bank_type");
        this.totalFee = WxPayOrderQueryResult.readXMLInteger(d, "total_fee");
        this.settlementTotalFee = WxPayOrderQueryResult.readXMLInteger(d, "settlement_total_fee");
        this.feeType = WxPayOrderQueryResult.readXMLString(d, "fee_type");
        this.cashFee = WxPayOrderQueryResult.readXMLInteger(d, "cash_fee");
        this.cashFeeType = WxPayOrderQueryResult.readXMLString(d, "cash_fee_type");
        this.couponFee = WxPayOrderQueryResult.readXMLInteger(d, "coupon_fee");
        this.couponCount = WxPayOrderQueryResult.readXMLInteger(d, "coupon_count");
        this.transactionId = WxPayOrderQueryResult.readXMLString(d, "transaction_id");
        this.outTradeNo = WxPayOrderQueryResult.readXMLString(d, "out_trade_no");
        this.attach = WxPayOrderQueryResult.readXMLString(d, "attach");
        this.timeEnd = WxPayOrderQueryResult.readXMLString(d, "time_end");
        this.tradeStateDesc = WxPayOrderQueryResult.readXMLString(d, "trade_state_desc");
    }

    public String getPromotionDetail() {
        return this.promotionDetail;
    }

    public String getDeviceInfo() {
        return this.deviceInfo;
    }

    public String getOpenid() {
        return this.openid;
    }

    public String getIsSubscribe() {
        return this.isSubscribe;
    }

    public String getSubOpenid() {
        return this.subOpenid;
    }

    public String getIsSubscribeSub() {
        return this.isSubscribeSub;
    }

    public String getTradeType() {
        return this.tradeType;
    }

    public String getTradeState() {
        return this.tradeState;
    }

    public String getBankType() {
        return this.bankType;
    }

    public String getDetail() {
        return this.detail;
    }

    public Integer getTotalFee() {
        return this.totalFee;
    }

    public String getFeeType() {
        return this.feeType;
    }

    public Integer getSettlementTotalFee() {
        return this.settlementTotalFee;
    }

    public Integer getCashFee() {
        return this.cashFee;
    }

    public String getCashFeeType() {
        return this.cashFeeType;
    }

    public Integer getCouponFee() {
        return this.couponFee;
    }

    public Integer getCouponCount() {
        return this.couponCount;
    }

    public List<Coupon> getCoupons() {
        return this.coupons;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    public String getAttach() {
        return this.attach;
    }

    public String getTimeEnd() {
        return this.timeEnd;
    }

    public String getTradeStateDesc() {
        return this.tradeStateDesc;
    }

    public void setPromotionDetail(String promotionDetail) {
        this.promotionDetail = promotionDetail;
    }

    public void setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public void setIsSubscribe(String isSubscribe) {
        this.isSubscribe = isSubscribe;
    }

    public void setSubOpenid(String subOpenid) {
        this.subOpenid = subOpenid;
    }

    public void setIsSubscribeSub(String isSubscribeSub) {
        this.isSubscribeSub = isSubscribeSub;
    }

    public void setTradeType(String tradeType) {
        this.tradeType = tradeType;
    }

    public void setTradeState(String tradeState) {
        this.tradeState = tradeState;
    }

    public void setBankType(String bankType) {
        this.bankType = bankType;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public void setTotalFee(Integer totalFee) {
        this.totalFee = totalFee;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public void setSettlementTotalFee(Integer settlementTotalFee) {
        this.settlementTotalFee = settlementTotalFee;
    }

    public void setCashFee(Integer cashFee) {
        this.cashFee = cashFee;
    }

    public void setCashFeeType(String cashFeeType) {
        this.cashFeeType = cashFeeType;
    }

    public void setCouponFee(Integer couponFee) {
        this.couponFee = couponFee;
    }

    public void setCouponCount(Integer couponCount) {
        this.couponCount = couponCount;
    }

    public void setCoupons(List<Coupon> coupons) {
        this.coupons = coupons;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public void setAttach(String attach) {
        this.attach = attach;
    }

    public void setTimeEnd(String timeEnd) {
        this.timeEnd = timeEnd;
    }

    public void setTradeStateDesc(String tradeStateDesc) {
        this.tradeStateDesc = tradeStateDesc;
    }

    @Override
    public String toString() {
        return "WxPayOrderQueryResult(promotionDetail=" + this.getPromotionDetail() + ", deviceInfo=" + this.getDeviceInfo() + ", openid=" + this.getOpenid() + ", isSubscribe=" + this.getIsSubscribe() + ", subOpenid=" + this.getSubOpenid() + ", isSubscribeSub=" + this.getIsSubscribeSub() + ", tradeType=" + this.getTradeType() + ", tradeState=" + this.getTradeState() + ", bankType=" + this.getBankType() + ", detail=" + this.getDetail() + ", totalFee=" + this.getTotalFee() + ", feeType=" + this.getFeeType() + ", settlementTotalFee=" + this.getSettlementTotalFee() + ", cashFee=" + this.getCashFee() + ", cashFeeType=" + this.getCashFeeType() + ", couponFee=" + this.getCouponFee() + ", couponCount=" + this.getCouponCount() + ", coupons=" + this.getCoupons() + ", transactionId=" + this.getTransactionId() + ", outTradeNo=" + this.getOutTradeNo() + ", attach=" + this.getAttach() + ", timeEnd=" + this.getTimeEnd() + ", tradeStateDesc=" + this.getTradeStateDesc() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxPayOrderQueryResult)) {
            return false;
        }
        WxPayOrderQueryResult other = (WxPayOrderQueryResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$promotionDetail = this.getPromotionDetail();
        String other$promotionDetail = other.getPromotionDetail();
        if (this$promotionDetail == null ? other$promotionDetail != null : !this$promotionDetail.equals(other$promotionDetail)) {
            return false;
        }
        String this$deviceInfo = this.getDeviceInfo();
        String other$deviceInfo = other.getDeviceInfo();
        if (this$deviceInfo == null ? other$deviceInfo != null : !this$deviceInfo.equals(other$deviceInfo)) {
            return false;
        }
        String this$openid = this.getOpenid();
        String other$openid = other.getOpenid();
        if (this$openid == null ? other$openid != null : !this$openid.equals(other$openid)) {
            return false;
        }
        String this$isSubscribe = this.getIsSubscribe();
        String other$isSubscribe = other.getIsSubscribe();
        if (this$isSubscribe == null ? other$isSubscribe != null : !this$isSubscribe.equals(other$isSubscribe)) {
            return false;
        }
        String this$subOpenid = this.getSubOpenid();
        String other$subOpenid = other.getSubOpenid();
        if (this$subOpenid == null ? other$subOpenid != null : !this$subOpenid.equals(other$subOpenid)) {
            return false;
        }
        String this$isSubscribeSub = this.getIsSubscribeSub();
        String other$isSubscribeSub = other.getIsSubscribeSub();
        if (this$isSubscribeSub == null ? other$isSubscribeSub != null : !this$isSubscribeSub.equals(other$isSubscribeSub)) {
            return false;
        }
        String this$tradeType = this.getTradeType();
        String other$tradeType = other.getTradeType();
        if (this$tradeType == null ? other$tradeType != null : !this$tradeType.equals(other$tradeType)) {
            return false;
        }
        String this$tradeState = this.getTradeState();
        String other$tradeState = other.getTradeState();
        if (this$tradeState == null ? other$tradeState != null : !this$tradeState.equals(other$tradeState)) {
            return false;
        }
        String this$bankType = this.getBankType();
        String other$bankType = other.getBankType();
        if (this$bankType == null ? other$bankType != null : !this$bankType.equals(other$bankType)) {
            return false;
        }
        String this$detail = this.getDetail();
        String other$detail = other.getDetail();
        if (this$detail == null ? other$detail != null : !this$detail.equals(other$detail)) {
            return false;
        }
        Integer this$totalFee = this.getTotalFee();
        Integer other$totalFee = other.getTotalFee();
        if (this$totalFee == null ? other$totalFee != null : !((Object)this$totalFee).equals(other$totalFee)) {
            return false;
        }
        String this$feeType = this.getFeeType();
        String other$feeType = other.getFeeType();
        if (this$feeType == null ? other$feeType != null : !this$feeType.equals(other$feeType)) {
            return false;
        }
        Integer this$settlementTotalFee = this.getSettlementTotalFee();
        Integer other$settlementTotalFee = other.getSettlementTotalFee();
        if (this$settlementTotalFee == null ? other$settlementTotalFee != null : !((Object)this$settlementTotalFee).equals(other$settlementTotalFee)) {
            return false;
        }
        Integer this$cashFee = this.getCashFee();
        Integer other$cashFee = other.getCashFee();
        if (this$cashFee == null ? other$cashFee != null : !((Object)this$cashFee).equals(other$cashFee)) {
            return false;
        }
        String this$cashFeeType = this.getCashFeeType();
        String other$cashFeeType = other.getCashFeeType();
        if (this$cashFeeType == null ? other$cashFeeType != null : !this$cashFeeType.equals(other$cashFeeType)) {
            return false;
        }
        Integer this$couponFee = this.getCouponFee();
        Integer other$couponFee = other.getCouponFee();
        if (this$couponFee == null ? other$couponFee != null : !((Object)this$couponFee).equals(other$couponFee)) {
            return false;
        }
        Integer this$couponCount = this.getCouponCount();
        Integer other$couponCount = other.getCouponCount();
        if (this$couponCount == null ? other$couponCount != null : !((Object)this$couponCount).equals(other$couponCount)) {
            return false;
        }
        List<Coupon> this$coupons = this.getCoupons();
        List<Coupon> other$coupons = other.getCoupons();
        if (this$coupons == null ? other$coupons != null : !((Object)this$coupons).equals(other$coupons)) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        if (this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId)) {
            return false;
        }
        String this$outTradeNo = this.getOutTradeNo();
        String other$outTradeNo = other.getOutTradeNo();
        if (this$outTradeNo == null ? other$outTradeNo != null : !this$outTradeNo.equals(other$outTradeNo)) {
            return false;
        }
        String this$attach = this.getAttach();
        String other$attach = other.getAttach();
        if (this$attach == null ? other$attach != null : !this$attach.equals(other$attach)) {
            return false;
        }
        String this$timeEnd = this.getTimeEnd();
        String other$timeEnd = other.getTimeEnd();
        if (this$timeEnd == null ? other$timeEnd != null : !this$timeEnd.equals(other$timeEnd)) {
            return false;
        }
        String this$tradeStateDesc = this.getTradeStateDesc();
        String other$tradeStateDesc = other.getTradeStateDesc();
        return !(this$tradeStateDesc == null ? other$tradeStateDesc != null : !this$tradeStateDesc.equals(other$tradeStateDesc));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WxPayOrderQueryResult;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $promotionDetail = this.getPromotionDetail();
        result = result * 59 + ($promotionDetail == null ? 43 : $promotionDetail.hashCode());
        String $deviceInfo = this.getDeviceInfo();
        result = result * 59 + ($deviceInfo == null ? 43 : $deviceInfo.hashCode());
        String $openid = this.getOpenid();
        result = result * 59 + ($openid == null ? 43 : $openid.hashCode());
        String $isSubscribe = this.getIsSubscribe();
        result = result * 59 + ($isSubscribe == null ? 43 : $isSubscribe.hashCode());
        String $subOpenid = this.getSubOpenid();
        result = result * 59 + ($subOpenid == null ? 43 : $subOpenid.hashCode());
        String $isSubscribeSub = this.getIsSubscribeSub();
        result = result * 59 + ($isSubscribeSub == null ? 43 : $isSubscribeSub.hashCode());
        String $tradeType = this.getTradeType();
        result = result * 59 + ($tradeType == null ? 43 : $tradeType.hashCode());
        String $tradeState = this.getTradeState();
        result = result * 59 + ($tradeState == null ? 43 : $tradeState.hashCode());
        String $bankType = this.getBankType();
        result = result * 59 + ($bankType == null ? 43 : $bankType.hashCode());
        String $detail = this.getDetail();
        result = result * 59 + ($detail == null ? 43 : $detail.hashCode());
        Integer $totalFee = this.getTotalFee();
        result = result * 59 + ($totalFee == null ? 43 : ((Object)$totalFee).hashCode());
        String $feeType = this.getFeeType();
        result = result * 59 + ($feeType == null ? 43 : $feeType.hashCode());
        Integer $settlementTotalFee = this.getSettlementTotalFee();
        result = result * 59 + ($settlementTotalFee == null ? 43 : ((Object)$settlementTotalFee).hashCode());
        Integer $cashFee = this.getCashFee();
        result = result * 59 + ($cashFee == null ? 43 : ((Object)$cashFee).hashCode());
        String $cashFeeType = this.getCashFeeType();
        result = result * 59 + ($cashFeeType == null ? 43 : $cashFeeType.hashCode());
        Integer $couponFee = this.getCouponFee();
        result = result * 59 + ($couponFee == null ? 43 : ((Object)$couponFee).hashCode());
        Integer $couponCount = this.getCouponCount();
        result = result * 59 + ($couponCount == null ? 43 : ((Object)$couponCount).hashCode());
        List<Coupon> $coupons = this.getCoupons();
        result = result * 59 + ($coupons == null ? 43 : ((Object)$coupons).hashCode());
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        String $outTradeNo = this.getOutTradeNo();
        result = result * 59 + ($outTradeNo == null ? 43 : $outTradeNo.hashCode());
        String $attach = this.getAttach();
        result = result * 59 + ($attach == null ? 43 : $attach.hashCode());
        String $timeEnd = this.getTimeEnd();
        result = result * 59 + ($timeEnd == null ? 43 : $timeEnd.hashCode());
        String $tradeStateDesc = this.getTradeStateDesc();
        result = result * 59 + ($tradeStateDesc == null ? 43 : $tradeStateDesc.hashCode());
        return result;
    }

    public static class Coupon
    implements Serializable {
        private static final long serialVersionUID = -954000582332155081L;
        private String couponType;
        private String couponId;
        private Integer couponFee;

        public static CouponBuilder newBuilder() {
            return new CouponBuilder();
        }

        public String getCouponType() {
            return this.couponType;
        }

        public String getCouponId() {
            return this.couponId;
        }

        public Integer getCouponFee() {
            return this.couponFee;
        }

        public void setCouponType(String couponType) {
            this.couponType = couponType;
        }

        public void setCouponId(String couponId) {
            this.couponId = couponId;
        }

        public void setCouponFee(Integer couponFee) {
            this.couponFee = couponFee;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Coupon)) {
                return false;
            }
            Coupon other = (Coupon)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$couponType = this.getCouponType();
            String other$couponType = other.getCouponType();
            if (this$couponType == null ? other$couponType != null : !this$couponType.equals(other$couponType)) {
                return false;
            }
            String this$couponId = this.getCouponId();
            String other$couponId = other.getCouponId();
            if (this$couponId == null ? other$couponId != null : !this$couponId.equals(other$couponId)) {
                return false;
            }
            Integer this$couponFee = this.getCouponFee();
            Integer other$couponFee = other.getCouponFee();
            return !(this$couponFee == null ? other$couponFee != null : !((Object)this$couponFee).equals(other$couponFee));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Coupon;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $couponType = this.getCouponType();
            result = result * 59 + ($couponType == null ? 43 : $couponType.hashCode());
            String $couponId = this.getCouponId();
            result = result * 59 + ($couponId == null ? 43 : $couponId.hashCode());
            Integer $couponFee = this.getCouponFee();
            result = result * 59 + ($couponFee == null ? 43 : ((Object)$couponFee).hashCode());
            return result;
        }

        public String toString() {
            return "WxPayOrderQueryResult.Coupon(couponType=" + this.getCouponType() + ", couponId=" + this.getCouponId() + ", couponFee=" + this.getCouponFee() + ")";
        }

        public Coupon(String couponType, String couponId, Integer couponFee) {
            this.couponType = couponType;
            this.couponId = couponId;
            this.couponFee = couponFee;
        }

        public static class CouponBuilder {
            private String couponType;
            private String couponId;
            private Integer couponFee;

            CouponBuilder() {
            }

            public CouponBuilder couponType(String couponType) {
                this.couponType = couponType;
                return this;
            }

            public CouponBuilder couponId(String couponId) {
                this.couponId = couponId;
                return this;
            }

            public CouponBuilder couponFee(Integer couponFee) {
                this.couponFee = couponFee;
                return this;
            }

            public Coupon build() {
                return new Coupon(this.couponType, this.couponId, this.couponFee);
            }

            public String toString() {
                return "WxPayOrderQueryResult.Coupon.CouponBuilder(couponType=" + this.couponType + ", couponId=" + this.couponId + ", couponFee=" + this.couponFee + ")";
            }
        }
    }
}

