/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar;

import com.github.junrar.Archive;
import com.github.junrar.ContentDescription;
import com.github.junrar.ExtractDestination;
import com.github.junrar.LocalFolderExtractor;
import com.github.junrar.VolumeManager;
import com.github.junrar.exception.RarException;
import com.github.junrar.impl.FileVolumeManager;
import com.github.junrar.rarfile.FileHeader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Junrar {
    private static Log logger = LogFactory.getLog((String)Junrar.class.getName());

    public static List<File> extract(String rarPath, String destinationPath) throws IOException, RarException {
        if (rarPath == null || destinationPath == null) {
            throw new RuntimeException("archive and destination must me set");
        }
        File arch = new File(rarPath);
        File dest = new File(destinationPath);
        return Junrar.extract(arch, dest);
    }

    public static List<File> extract(File rar, File destinationFolder) throws RarException, IOException {
        Junrar.validateRarPath(rar);
        Junrar.validateDestinationPath(destinationFolder);
        Archive archive = Junrar.createArchiveOrThrowException(logger, rar);
        LocalFolderExtractor lfe = new LocalFolderExtractor(destinationFolder);
        return Junrar.extractArchiveTo(archive, lfe);
    }

    public static List<File> extract(InputStream resourceAsStream, File destinationFolder) throws RarException, IOException {
        Junrar.validateDestinationPath(destinationFolder);
        Archive arch = Junrar.createArchiveOrThrowException(logger, resourceAsStream);
        LocalFolderExtractor lfe = new LocalFolderExtractor(destinationFolder);
        return Junrar.extractArchiveTo(arch, lfe);
    }

    public static List<File> extract(ExtractDestination destination, VolumeManager volumeManager) throws RarException, IOException {
        Archive archive = new Archive(volumeManager);
        return Junrar.extractArchiveTo(archive, destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ContentDescription> getContentsDescription(File rar) throws RarException, IOException {
        Junrar.validateRarPath(rar);
        Archive arch = Junrar.createArchiveOrThrowException(logger, rar);
        ArrayList<ContentDescription> contents = new ArrayList<ContentDescription>();
        try {
            if (arch.isEncrypted()) {
                logger.warn((Object)"archive is encrypted cannot extract");
                ArrayList<ContentDescription> arrayList = new ArrayList<ContentDescription>();
                return arrayList;
            }
            for (FileHeader fileHeader : arch) {
                contents.add(new ContentDescription(fileHeader.getFileNameString(), fileHeader.getUnpSize()));
            }
        }
        finally {
            arch.close();
        }
        return contents;
    }

    private static Archive createArchiveOrThrowException(Log logger, InputStream rarAsStream) throws RarException, IOException {
        try {
            return new Archive(rarAsStream);
        }
        catch (RarException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (IOException e1) {
            logger.error((Object)e1);
            throw e1;
        }
    }

    private static Archive createArchiveOrThrowException(Log logger, File file) throws RarException, IOException {
        try {
            return new Archive(new FileVolumeManager(file));
        }
        catch (RarException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (IOException e1) {
            logger.error((Object)e1);
            throw e1;
        }
    }

    private static void validateDestinationPath(File destinationFolder) {
        if (destinationFolder == null) {
            throw new RuntimeException("archive and destination must me set");
        }
        if (!destinationFolder.exists() || !destinationFolder.isDirectory()) {
            throw new IllegalArgumentException("the destination must exist and point to a directory: " + destinationFolder);
        }
    }

    private static void validateRarPath(File rar) {
        if (rar == null) {
            throw new RuntimeException("archive and destination must me set");
        }
        if (!rar.exists()) {
            throw new IllegalArgumentException("the archive does not exit: " + rar);
        }
        if (!rar.isFile()) {
            throw new IllegalArgumentException("First argument should be a file but was " + rar.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<File> extractArchiveTo(Archive arch, ExtractDestination destination) throws IOException, RarException {
        if (arch.isEncrypted()) {
            logger.warn((Object)"archive is encrypted cannot extract");
            arch.close();
            return new ArrayList<File>();
        }
        ArrayList<File> extractedFiles = new ArrayList<File>();
        try {
            for (FileHeader fh : arch) {
                try {
                    File file = Junrar.tryToExtract(logger, destination, arch, fh);
                    if (file == null) continue;
                    extractedFiles.add(file);
                }
                catch (IOException e) {
                    logger.error((Object)"error extracting the file", (Throwable)e);
                    throw e;
                }
                catch (RarException e) {
                    logger.error((Object)"error extraction the file", (Throwable)e);
                    throw e;
                    return extractedFiles;
                }
            }
        }
        finally {
            arch.close();
        }
    }

    private static File tryToExtract(Log logger, ExtractDestination destination, Archive arch, FileHeader fileHeader) throws IOException, RarException {
        String fileNameString = fileHeader.getFileNameString();
        if (fileHeader.isEncrypted()) {
            logger.warn((Object)("file is encrypted cannot extract: " + fileNameString));
            return null;
        }
        logger.info((Object)("extracting: " + fileNameString));
        if (fileHeader.isDirectory()) {
            return destination.createDirectory(fileHeader);
        }
        return destination.extract(arch, fileHeader);
    }
}

