/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper;

public enum Dialect {
    mysql,
    mariadb,
    sqlite,
    oracle,
    hsqldb,
    postgresql,
    sqlserver,
    db2,
    informix,
    h2;


    public static Dialect of(String dialect) {
        try {
            Dialect d = Dialect.valueOf(dialect.toLowerCase());
            return d;
        }
        catch (IllegalArgumentException e) {
            String dialects = null;
            for (Dialect d : Dialect.values()) {
                dialects = dialects == null ? d.toString() : dialects + "," + (Object)((Object)d);
            }
            throw new IllegalArgumentException("Mybatis\u5206\u9875\u63d2\u4ef6dialect\u53c2\u6570\u503c\u9519\u8bef\uff0c\u53ef\u9009\u503c\u4e3a[" + dialects + "]");
        }
    }

    public static String[] dialects() {
        Dialect[] dialects = Dialect.values();
        String[] ds = new String[dialects.length];
        for (int i = 0; i < dialects.length; ++i) {
            ds[i] = dialects[i].toString();
        }
        return ds;
    }

    public static String fromJdbcUrl(String jdbcUrl) {
        String[] dialects;
        for (String dialect : dialects = Dialect.dialects()) {
            if (jdbcUrl.indexOf(":" + dialect + ":") == -1) continue;
            return dialect;
        }
        return null;
    }
}

