/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper;

import com.github.orderbyhelper.sqlsource.OrderBySqlSource;
import com.github.pagehelper.Constant;
import com.github.pagehelper.Dialect;
import com.github.pagehelper.MSUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.ReturnPageInfo;
import com.github.pagehelper.parser.Parser;
import com.github.pagehelper.parser.impl.AbstractParser;
import com.github.pagehelper.sqlsource.PageDynamicSqlSource;
import com.github.pagehelper.sqlsource.PageProviderSqlSource;
import com.github.pagehelper.sqlsource.PageRawSqlSource;
import com.github.pagehelper.sqlsource.PageSqlSource;
import com.github.pagehelper.sqlsource.PageStaticSqlSource;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.builder.StaticSqlSource;
import org.apache.ibatis.builder.annotation.ProviderSqlSource;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.scripting.defaults.RawSqlSource;
import org.apache.ibatis.scripting.xmltags.DynamicSqlSource;
import org.apache.ibatis.session.RowBounds;

public class SqlUtil
implements Constant {
    private static final ThreadLocal<Page> LOCAL_PAGE = new ThreadLocal();
    private static Map<String, String> PARAMS = new HashMap<String, String>(5);
    private static Boolean hasRequest;
    private static Class<?> requestClass;
    private static Method getParameterMap;
    private final Map<String, MappedStatement> msCountMap = new ConcurrentHashMap<String, MappedStatement>();
    private boolean offsetAsPageNum = false;
    private boolean rowBoundsWithCount = false;
    private boolean pageSizeZero = false;
    private boolean reasonable = false;
    private Parser parser;
    private ReturnPageInfo returnPageInfo = ReturnPageInfo.NONE;
    private Map<String, Boolean> returnPageInfoMap = new ConcurrentHashMap<String, Boolean>();
    private boolean supportMethodsArguments = false;

    public SqlUtil(String strDialect) {
        if (strDialect == null || "".equals(strDialect)) {
            throw new IllegalArgumentException("Mybatis\u5206\u9875\u63d2\u4ef6\u65e0\u6cd5\u83b7\u53d6dialect\u53c2\u6570!");
        }
        Exception exception = null;
        try {
            Dialect dialect = Dialect.of(strDialect);
            this.parser = AbstractParser.newParser(dialect);
        }
        catch (Exception e) {
            exception = e;
            try {
                Class<?> parserClass = Class.forName(strDialect);
                if (Parser.class.isAssignableFrom(parserClass)) {
                    this.parser = (Parser)parserClass.newInstance();
                }
            }
            catch (ClassNotFoundException ex) {
                exception = ex;
            }
            catch (InstantiationException ex) {
                exception = ex;
            }
            catch (IllegalAccessException ex) {
                exception = ex;
            }
        }
        if (this.parser == null) {
            throw new RuntimeException(exception);
        }
    }

    public static Boolean getCOUNT() {
        Page page = SqlUtil.getLocalPage();
        if (page != null) {
            return page.getCountSignal();
        }
        return null;
    }

    public static Page getLocalPage() {
        return LOCAL_PAGE.get();
    }

    public static void setLocalPage(Page page) {
        LOCAL_PAGE.set(page);
    }

    public static void clearLocalPage() {
        LOCAL_PAGE.remove();
    }

    public static Page getPageFromObject(Object params) {
        Object pageSizeZero;
        Object reasonable;
        int pageSize;
        int pageNum;
        MetaObject paramsObject = null;
        if (params == null) {
            throw new NullPointerException("\u65e0\u6cd5\u83b7\u53d6\u5206\u9875\u67e5\u8be2\u53c2\u6570!");
        }
        if (hasRequest.booleanValue() && requestClass.isAssignableFrom(params.getClass())) {
            try {
                paramsObject = SystemMetaObject.forObject((Object)getParameterMap.invoke(params, new Object[0]));
            }
            catch (Exception exception) {}
        } else {
            paramsObject = SystemMetaObject.forObject((Object)params);
        }
        if (paramsObject == null) {
            throw new NullPointerException("\u5206\u9875\u67e5\u8be2\u53c2\u6570\u5904\u7406\u5931\u8d25!");
        }
        Object orderBy = SqlUtil.getParamValue(paramsObject, "orderBy", false);
        boolean hasOrderBy = false;
        if (orderBy != null && orderBy.toString().length() > 0) {
            hasOrderBy = true;
        }
        try {
            Object _pageNum = SqlUtil.getParamValue(paramsObject, "pageNum", !hasOrderBy);
            Object _pageSize = SqlUtil.getParamValue(paramsObject, "pageSize", !hasOrderBy);
            if (_pageNum == null || _pageSize == null) {
                Page page = new Page();
                page.setOrderBy(orderBy.toString());
                page.setOrderByOnly(true);
                return page;
            }
            pageNum = Integer.parseInt(String.valueOf(_pageNum));
            pageSize = Integer.parseInt(String.valueOf(_pageSize));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("\u5206\u9875\u53c2\u6570\u4e0d\u662f\u5408\u6cd5\u7684\u6570\u5b57\u7c7b\u578b!");
        }
        Page page = new Page(pageNum, pageSize);
        Object _count = SqlUtil.getParamValue(paramsObject, "count", false);
        if (_count != null) {
            page.setCount(Boolean.valueOf(String.valueOf(_count)));
        }
        if (hasOrderBy) {
            page.setOrderBy(orderBy.toString());
        }
        if ((reasonable = SqlUtil.getParamValue(paramsObject, "reasonable", false)) != null) {
            page.setReasonable(Boolean.valueOf(String.valueOf(reasonable)));
        }
        if ((pageSizeZero = SqlUtil.getParamValue(paramsObject, "pageSizeZero", false)) != null) {
            page.setPageSizeZero(Boolean.valueOf(String.valueOf(pageSizeZero)));
        }
        return page;
    }

    public static Object getParamValue(MetaObject paramsObject, String paramName, boolean required) {
        Object value = null;
        if (paramsObject.hasGetter(PARAMS.get(paramName))) {
            value = paramsObject.getValue(PARAMS.get(paramName));
        }
        if (value != null && value.getClass().isArray()) {
            Object[] values = (Object[])value;
            value = values.length == 0 ? null : values[0];
        }
        if (required && value == null) {
            throw new RuntimeException("\u5206\u9875\u67e5\u8be2\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570:" + PARAMS.get(paramName));
        }
        return value;
    }

    public static boolean isPageSqlSource(MappedStatement ms) {
        return ms.getSqlSource() instanceof PageSqlSource;
    }

    public static void testSql(String dialect, String originalSql) {
        SqlUtil.testSql(Dialect.of(dialect), originalSql);
    }

    public static void testSql(Dialect dialect, String originalSql) {
        Parser parser = AbstractParser.newParser(dialect);
        if (dialect == Dialect.sqlserver) {
            SqlUtil.setLocalPage(new Page(1, 10));
        }
        String countSql = parser.getCountSql(originalSql);
        System.out.println(countSql);
        String pageSql = parser.getPageSql(originalSql);
        System.out.println(pageSql);
        if (dialect == Dialect.sqlserver) {
            SqlUtil.clearLocalPage();
        }
    }

    public void processMappedStatement(MappedStatement ms, Parser parser) throws Throwable {
        PageSqlSource pageSqlSource;
        SqlSource sqlSource = ms.getSqlSource();
        MetaObject msObject = SystemMetaObject.forObject((Object)ms);
        SqlSource tempSqlSource = sqlSource;
        if (sqlSource instanceof OrderBySqlSource) {
            tempSqlSource = ((OrderBySqlSource)tempSqlSource).getOriginal();
        }
        if (tempSqlSource instanceof StaticSqlSource) {
            pageSqlSource = new PageStaticSqlSource((StaticSqlSource)tempSqlSource, parser);
        } else if (tempSqlSource instanceof RawSqlSource) {
            pageSqlSource = new PageRawSqlSource((RawSqlSource)tempSqlSource, parser);
        } else if (tempSqlSource instanceof ProviderSqlSource) {
            pageSqlSource = new PageProviderSqlSource((ProviderSqlSource)tempSqlSource, parser);
        } else if (tempSqlSource instanceof DynamicSqlSource) {
            pageSqlSource = new PageDynamicSqlSource((DynamicSqlSource)tempSqlSource, parser);
        } else {
            throw new RuntimeException("\u65e0\u6cd5\u5904\u7406\u8be5\u7c7b\u578b[" + sqlSource.getClass() + "]\u7684SqlSource");
        }
        msObject.setValue("sqlSource", (Object)pageSqlSource);
        this.msCountMap.put(ms.getId(), MSUtils.newCountMappedStatement(ms));
    }

    public Page getPage(Object[] args) {
        Page page = SqlUtil.getLocalPage();
        if (page == null || page.isOrderByOnly()) {
            Page oldPage = page;
            if ((args[2] == null || args[2] == RowBounds.DEFAULT) && page != null) {
                return oldPage;
            }
            if (args[2] instanceof RowBounds && args[2] != RowBounds.DEFAULT) {
                RowBounds rowBounds = (RowBounds)args[2];
                if (this.offsetAsPageNum) {
                    page = new Page(rowBounds.getOffset(), rowBounds.getLimit(), this.rowBoundsWithCount);
                } else {
                    page = new Page(new int[]{rowBounds.getOffset(), rowBounds.getLimit()}, this.rowBoundsWithCount);
                    page.setReasonable(false);
                }
            } else {
                try {
                    page = SqlUtil.getPageFromObject(args[1]);
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (oldPage != null) {
                page.setOrderBy(oldPage.getOrderBy());
            }
            SqlUtil.setLocalPage(page);
        }
        if (page.getReasonable() == null) {
            page.setReasonable(this.reasonable);
        }
        if (page.getPageSizeZero() == null) {
            page.setPageSizeZero(this.pageSizeZero);
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processPage(Invocation invocation) throws Throwable {
        try {
            Object result;
            Object object = result = this._processPage(invocation);
            return object;
        }
        finally {
            SqlUtil.clearLocalPage();
        }
    }

    private Object _processPage(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        Page page = null;
        if (this.supportMethodsArguments) {
            page = this.getPage(args);
        }
        RowBounds rowBounds = (RowBounds)args[2];
        if (this.supportMethodsArguments && page == null || !this.supportMethodsArguments && SqlUtil.getLocalPage() == null && rowBounds == RowBounds.DEFAULT) {
            return invocation.proceed();
        }
        if (page == null) {
            page = this.getPage(args);
        }
        page = this.doProcessPage(invocation, page, args);
        return this.processPageInfo(page, args);
    }

    private Object processPageInfo(Page<?> page, Object[] args) {
        switch (this.returnPageInfo) {
            case NONE: {
                return page;
            }
            case ALWAYS: {
                return this.returnPageInfo(page);
            }
            case CHECK: {
                if (this.isReturnPageInfo((MappedStatement)args[0])) {
                    return this.returnPageInfo(page);
                }
                return page;
            }
        }
        return page;
    }

    private Object returnPageInfo(Page<?> page) {
        ArrayList list = new ArrayList();
        list.add(new PageInfo(page));
        return list;
    }

    private boolean isReturnPageInfo(MappedStatement ms) {
        String msId = ms.getId();
        if (!this.returnPageInfoMap.containsKey(msId)) {
            String _interface = msId.substring(0, msId.lastIndexOf("."));
            String _methodName = msId.substring(_interface.length() + 1);
            try {
                Class<?> mapperClass = Class.forName(_interface);
                Method[] methods = mapperClass.getDeclaredMethods();
                Method m = null;
                for (Method method : methods) {
                    if (!method.getName().equals(_methodName)) continue;
                    m = method;
                    break;
                }
                if (m == null) {
                    this.returnPageInfoMap.put(msId, false);
                } else {
                    Class<?> returnClass = m.getReturnType();
                    if (returnClass.equals(PageInfo.class)) {
                        this.returnPageInfoMap.put(msId, true);
                    } else {
                        this.returnPageInfoMap.put(msId, false);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                this.returnPageInfoMap.put(msId, false);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.returnPageInfoMap.get(msId);
    }

    private boolean isQueryOnly(Page page) {
        return page.isOrderByOnly() || page.getPageSizeZero() != null && page.getPageSizeZero() != false && page.getPageSize() == 0;
    }

    private Page doQueryOnly(Page page, Invocation invocation) throws Throwable {
        page.setCountSignal(null);
        Object result = invocation.proceed();
        page.addAll((List)result);
        page.setPageNum(1);
        page.setPageSize(page.size());
        page.setTotal(page.size());
        return page;
    }

    private Page doProcessPage(Invocation invocation, Page page, Object[] args) throws Throwable {
        RowBounds rowBounds = (RowBounds)args[2];
        MappedStatement ms = (MappedStatement)args[0];
        if (!SqlUtil.isPageSqlSource(ms)) {
            this.processMappedStatement(ms, this.parser);
        }
        args[2] = RowBounds.DEFAULT;
        if (this.isQueryOnly(page)) {
            return this.doQueryOnly(page, invocation);
        }
        if (page.isCount()) {
            page.setCountSignal(Boolean.TRUE);
            args[0] = this.msCountMap.get(ms.getId());
            Object result = invocation.proceed();
            args[0] = ms;
            page.setTotal(((Integer)((List)result).get(0)).intValue());
            if (page.getTotal() == 0L) {
                return page;
            }
        } else {
            page.setTotal(-1L);
        }
        if (page.getPageSize() > 0 && (rowBounds == RowBounds.DEFAULT && page.getPageNum() > 0 || rowBounds != RowBounds.DEFAULT)) {
            page.setCountSignal(null);
            BoundSql boundSql = ms.getBoundSql(args[1]);
            args[1] = this.parser.setPageParameter(ms, args[1], boundSql, page);
            page.setCountSignal(Boolean.FALSE);
            Object result = invocation.proceed();
            page.addAll((List)result);
        }
        return page;
    }

    public void setProperties(Properties p) {
        String offsetAsPageNum = p.getProperty("offsetAsPageNum");
        this.offsetAsPageNum = Boolean.parseBoolean(offsetAsPageNum);
        String rowBoundsWithCount = p.getProperty("rowBoundsWithCount");
        this.rowBoundsWithCount = Boolean.parseBoolean(rowBoundsWithCount);
        String pageSizeZero = p.getProperty("pageSizeZero");
        this.pageSizeZero = Boolean.parseBoolean(pageSizeZero);
        String reasonable = p.getProperty("reasonable");
        this.reasonable = Boolean.parseBoolean(reasonable);
        String supportMethodsArguments = p.getProperty("supportMethodsArguments");
        this.supportMethodsArguments = Boolean.parseBoolean(supportMethodsArguments);
        String returnPageInfo = p.getProperty("returnPageInfo");
        if (returnPageInfo != null && returnPageInfo.length() > 0) {
            this.returnPageInfo = ReturnPageInfo.valueOf(returnPageInfo.toUpperCase());
        }
        PARAMS.put("pageNum", "pageNum");
        PARAMS.put("pageSize", "pageSize");
        PARAMS.put("count", "countSql");
        PARAMS.put("orderBy", "orderBy");
        PARAMS.put("reasonable", "reasonable");
        PARAMS.put("pageSizeZero", "pageSizeZero");
        String params = p.getProperty("params");
        if (params != null && params.length() > 0) {
            String[] ps;
            for (String s : ps = params.split("[;|,|&]")) {
                String[] ss = s.split("[=|:]");
                if (ss.length != 2) continue;
                PARAMS.put(ss[0], ss[1]);
            }
        }
    }

    static {
        try {
            requestClass = Class.forName("javax.servlet.ServletRequest");
            getParameterMap = requestClass.getMethod("getParameterMap", new Class[0]);
            hasRequest = true;
        }
        catch (Exception e) {
            hasRequest = false;
        }
    }
}

