package com.jarvis.cache.lock;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import redis.clients.jedis.Jedis;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;

/**
 * 
 * @author: jiayu.qiu
 */
public class ShardedJedisLock extends AbstractRedisLock {

    private static final Logger logger=LoggerFactory.getLogger(ShardedJedisLock.class);

    private ShardedJedisPool shardedJedisPool;

    public ShardedJedisLock(ShardedJedisPool shardedJedisPool) {
        this.shardedJedisPool=shardedJedisPool;
    }

    private void returnResource(ShardedJedis shardedJedis) {
        shardedJedis.close();
    }

    @Override
    protected Long setnx(String key, String val) {
        ShardedJedis shardedJedis=null;
        try {
            shardedJedis=shardedJedisPool.getResource();
            Jedis jedis=shardedJedis.getShard(key);
            return jedis.setnx(key, val);
        } catch(Exception ex) {
            logger.error(ex.getMessage(), ex);
        } finally {
            returnResource(shardedJedis);
        }
        return 0L;
    }

    @Override
    protected void expire(String key, int expire) {
        ShardedJedis shardedJedis=null;
        try {
            shardedJedis=shardedJedisPool.getResource();
            Jedis jedis=shardedJedis.getShard(key);
            jedis.expire(key, expire);
        } catch(Exception ex) {
            logger.error(ex.getMessage(), ex);
        } finally {
            returnResource(shardedJedis);
        }
    }

    @Override
    protected String get(String key) {
        ShardedJedis shardedJedis=null;
        try {
            shardedJedis=shardedJedisPool.getResource();
            Jedis jedis=shardedJedis.getShard(key);
            return jedis.get(key);
        } finally {
            returnResource(shardedJedis);
        }
    }

    @Override
    protected String getSet(String key, String newVal) {
        ShardedJedis shardedJedis=null;
        try {
            shardedJedis=shardedJedisPool.getResource();
            Jedis jedis=shardedJedis.getShard(key);
            return jedis.getSet(key, newVal);
        } finally {
            returnResource(shardedJedis);
        }
    }

    @Override
    protected void del(String key) {
        ShardedJedis shardedJedis=null;
        try {
            shardedJedis=shardedJedisPool.getResource();
            Jedis jedis=shardedJedis.getShard(key);
            jedis.del(key);
        } finally {
            returnResource(shardedJedis);
        }
    }

}
