/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class LazyValue<T> {
    private Supplier<T> supplier;
    private T value;

    public LazyValue(T value) {
        this.value = value;
    }

    public LazyValue(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public boolean isInitialized() {
        return this.supplier == null;
    }

    protected T load() {
        if (this.supplier != null) {
            T obj = this.supplier.get();
            this.supplier = null;
            return obj;
        }
        return this.value;
    }

    public void ifPresent(Consumer<T> action) {
        if (this.isInitialized() && this.value != null) {
            action.accept(this.value);
        }
    }

    public void ifPresentNullable(Consumer<Optional<T>> action) {
        if (this.isInitialized()) {
            action.accept(Optional.ofNullable(this.value));
        }
    }

    public T get() {
        if (this.value == null) {
            this.value = this.load();
        }
        return this.value;
    }
}

