/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger.config;

import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CheckReturnValue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@CheckReturnValue
public final class JdkLoggerConfig {
    private static final Map<String, JdkLoggerConfig> strongRefMap = new ConcurrentHashMap<String, JdkLoggerConfig>();
    private final Logger logger;

    public static JdkLoggerConfig getRootConfig() {
        return JdkLoggerConfig.getConfig("");
    }

    public static JdkLoggerConfig getGoogleConfig() {
        return JdkLoggerConfig.getConfig("com.google");
    }

    public static JdkLoggerConfig getConfig(Class<?> clazz) {
        return JdkLoggerConfig.getConfig(clazz.getName().replace('$', '.'));
    }

    public static JdkLoggerConfig getConfig(String name) {
        JdkLoggerConfig config = strongRefMap.get(JdkLoggerConfig.checkNotNull(name, "logger name must not be null"));
        if (config == null) {
            config = new JdkLoggerConfig(name);
            strongRefMap.put(name, config);
        }
        return config;
    }

    public static JdkLoggerConfig getPackageConfig(Class<?> clazz) {
        return JdkLoggerConfig.getConfig(clazz.getPackage().getName());
    }

    private JdkLoggerConfig(String name) {
        this.logger = JdkLoggerConfig.checkNotNull(Logger.getLogger(name), "cannot fetch underlying JDK logger");
    }

    public void setFilter(@NullableDecl Filter newFilter) {
        this.logger.setFilter(newFilter);
    }

    @NullableDecl
    public Filter getFilter() {
        return this.logger.getFilter();
    }

    public void setLevel(@NullableDecl Level newLevel) {
        this.logger.setLevel(newLevel);
    }

    @NullableDecl
    public Level getLevel() {
        return this.logger.getLevel();
    }

    public String getName() {
        return this.logger.getName();
    }

    public void addHandler(Handler handler) {
        JdkLoggerConfig.checkNotNull(handler, "handler must not be null");
        this.logger.addHandler(handler);
    }

    public void removeHandler(Handler handler) {
        JdkLoggerConfig.checkNotNull(handler, "handler must not be null");
        this.logger.removeHandler(handler);
    }

    public Handler[] getHandlers() {
        return this.logger.getHandlers();
    }

    public void setUseParentHandlers(boolean useParentHandlers) {
        this.logger.setUseParentHandlers(useParentHandlers);
    }

    public boolean getUseParentHandlers() {
        return this.logger.getUseParentHandlers();
    }

    @CanIgnoreReturnValue
    private static <T> T checkNotNull(T ref, String message) {
        if (ref == null) {
            throw new NullPointerException(message);
        }
        return ref;
    }
}

