/*
 * Decompiled with CFR 0.152.
 */
package oe.maven.plugins.revision;

import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import oe.maven.plugins.revision.Entry;
import oe.maven.plugins.revision.EntryStatusSymbols;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevisionMojo
extends AbstractMojo {
    private MavenProject project;
    private Entry[] entries;
    private boolean verbose;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.entries == null) {
            this.logDebug("the entries configuration is missing, using default values");
            this.entries = new Entry[]{new Entry(this.project.getBasedir(), this.project.getArtifactId())};
        } else if (this.entries.length == 0) {
            throw new MojoExecutionException("the entries configuration list is empty");
        }
        SVNStatusClient statusClient = SVNClientManager.newInstance().getStatusClient();
        for (Entry entry : this.entries) {
            if (entry.getPath() == null) {
                this.logDebug("the entry path is not specified, using project.basedir: " + this.project.getBasedir());
                entry.setPath(this.project.getBasedir());
            }
            this.logInfo("inspecting " + entry.getPath());
            if (entry.getPrefix() == null) {
                this.logDebug("the entry prefix is not specified, using project.artifactId: " + this.project.getArtifactId());
                entry.setPrefix(this.project.getArtifactId());
            }
            this.logDebugInfo("  prefix = " + entry.getPrefix());
            this.logDebugInfo("  depth = " + entry.getDepth());
            this.logDebugInfo("  report unversioned = " + entry.reportUnversioned());
            this.logDebugInfo("  report ignored = " + entry.reportIgnored());
            this.logDebugInfo("  report out-of-date = " + entry.reportOutOfDate());
            entry.validate();
            Map<String, Object> entryProperties = this.getEntryProperties(entry, statusClient);
            this.setProjectProperties(entry.getPrefix(), entryProperties);
        }
    }

    private Map<String, Object> getEntryProperties(Entry entry, SVNStatusClient statusClient) throws MojoExecutionException {
        try {
            SVNStatus status = statusClient.doStatus(entry.getPath(), false);
            return this.createVersionedEntryProperties(entry, status, statusClient);
        }
        catch (SVNException e) {
            SVNErrorCode errorCode;
            SVNErrorCode sVNErrorCode = errorCode = e.getErrorMessage() == null ? null : e.getErrorMessage().getErrorCode();
            if (SVNErrorCode.WC_NOT_DIRECTORY.equals((Object)errorCode)) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((Throwable)e);
                }
                return this.createUnversionedEntryProperties();
            }
            if (this.getLog().isErrorEnabled()) {
                this.getLog().error((Throwable)e);
            }
            return this.createSpecialEntryProperties(entry, statusClient);
        }
    }

    private Map<String, Object> createUnversionedEntryProperties() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put("repository", "");
        properties.put("path", "");
        properties.put("revision", -1L);
        properties.put("mixedRevisions", "false");
        properties.put("committedRevision", -1L);
        properties.put("committedDate", "");
        properties.put("status", Character.valueOf(EntryStatusSymbols.DEFAULT.getStatusSymbol(SVNStatusType.STATUS_UNVERSIONED)));
        properties.put("specialStatus", Character.valueOf(EntryStatusSymbols.SPECIAL.getStatusSymbol(SVNStatusType.STATUS_UNVERSIONED)));
        return properties;
    }

    private Map<String, Object> createVersionedEntryProperties(Entry entry, SVNStatus status, SVNStatusClient statusClient) throws MojoExecutionException {
        VersionedEntryStatusHandler entryStatusHandler = new VersionedEntryStatusHandler();
        entryStatusHandler.setRepositoryProperties(status.getEntry());
        try {
            this.logDebugInfo(" collecting status information");
            statusClient.doStatus(entry.getPath(), SVNRevision.WORKING, SVNDepth.fromString((String)entry.getDepth()), entry.reportOutOfDate(), true, entry.reportIgnored(), false, (ISVNStatusHandler)entryStatusHandler, null);
        }
        catch (SVNException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put("repository", entryStatusHandler.getRepositoryRoot());
        properties.put("path", entryStatusHandler.getRepositoryPath());
        properties.put("revision", entryStatusHandler.getMaximumRevisionNumber());
        properties.put("mixedRevisions", entryStatusHandler.isMixedRevisions());
        properties.put("committedRevision", entryStatusHandler.getMaximumCommittedRevisionNumber());
        properties.put("committedDate", entryStatusHandler.getMaximumCommittedRevisionDate());
        properties.put("status", this.createStatusString(entry, entryStatusHandler.getLocalStatusTypes(), entryStatusHandler.getRemoteStatusTypes(), EntryStatusSymbols.DEFAULT));
        properties.put("specialStatus", this.createStatusString(entry, entryStatusHandler.getLocalStatusTypes(), entryStatusHandler.getRemoteStatusTypes(), EntryStatusSymbols.SPECIAL));
        return properties;
    }

    private Map<String, Object> createSpecialEntryProperties(Entry entry, SVNStatusClient statusClient) throws MojoExecutionException {
        SpecialEntryStatusHandler entryStatusHandler = new SpecialEntryStatusHandler(entry.getPath().getName());
        try {
            this.logDebugInfo(" collecting status information from the entry parent");
            statusClient.doStatus(entry.getPath().getParentFile(), SVNRevision.WORKING, SVNDepth.IMMEDIATES, false, true, entry.reportIgnored(), false, (ISVNStatusHandler)entryStatusHandler, null);
        }
        catch (SVNException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put("repository", entryStatusHandler.getRepositoryRoot());
        properties.put("path", entryStatusHandler.getRepositoryPath());
        properties.put("revision", entryStatusHandler.getMaximumRevisionNumber());
        properties.put("mixedRevisions", entryStatusHandler.isMixedRevisions());
        properties.put("committedRevision", entryStatusHandler.getMaximumCommittedRevisionNumber());
        properties.put("committedDate", entryStatusHandler.getMaximumCommittedRevisionDate());
        properties.put("status", this.createStatusString(entry, entryStatusHandler.getLocalStatusTypes(), entryStatusHandler.getRemoteStatusTypes(), EntryStatusSymbols.DEFAULT));
        properties.put("specialStatus", this.createStatusString(entry, entryStatusHandler.getLocalStatusTypes(), entryStatusHandler.getRemoteStatusTypes(), EntryStatusSymbols.SPECIAL));
        return properties;
    }

    private void setProjectProperties(String prefix, Map<String, Object> entryProperties) {
        this.logDebugInfo(" setting properties");
        for (Map.Entry<String, Object> entryProperty : entryProperties.entrySet()) {
            this.setProjectProperty(prefix + '.' + entryProperty.getKey(), String.valueOf(entryProperty.getValue()));
        }
    }

    private void setProjectProperty(String name, String value) {
        Properties projectProperties = this.project.getProperties();
        if (projectProperties.getProperty(name) != null) {
            this.logWarning("the \"" + name + "\" property is already defined, its value will be overwritten. Consider another value for the entry properties prefix.");
        }
        projectProperties.setProperty(name, value);
        this.logDebugInfo("  " + name + " = " + value);
    }

    private String createStatusString(Entry entry, Set<SVNStatusType> localStatusTypes, Set<SVNStatusType> remoteStatusTypes, EntryStatusSymbols symbols) {
        StringBuilder status = new StringBuilder();
        localStatusTypes.remove(SVNStatusType.STATUS_NONE);
        localStatusTypes.remove(SVNStatusType.STATUS_NORMAL);
        if (localStatusTypes.remove(SVNStatusType.STATUS_ADDED)) {
            status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_ADDED));
        }
        if (localStatusTypes.remove(SVNStatusType.STATUS_CONFLICTED)) {
            status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_CONFLICTED));
        }
        if (localStatusTypes.remove(SVNStatusType.STATUS_DELETED)) {
            status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_DELETED));
        }
        if (localStatusTypes.remove(SVNStatusType.STATUS_IGNORED) && entry.reportIgnored()) {
            status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_IGNORED));
        }
        if (localStatusTypes.remove(SVNStatusType.STATUS_MODIFIED)) {
            status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_MODIFIED));
        }
        if (localStatusTypes.remove(SVNStatusType.STATUS_REPLACED)) {
            status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_REPLACED));
        }
        if (localStatusTypes.remove(SVNStatusType.STATUS_EXTERNAL)) {
            status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_EXTERNAL));
        }
        if (localStatusTypes.remove(SVNStatusType.STATUS_UNVERSIONED) && entry.reportUnversioned()) {
            status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_UNVERSIONED));
        }
        if (localStatusTypes.remove(SVNStatusType.STATUS_MISSING)) {
            status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_MISSING));
        }
        if (localStatusTypes.remove(SVNStatusType.STATUS_INCOMPLETE)) {
            status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_INCOMPLETE));
        }
        if (localStatusTypes.remove(SVNStatusType.STATUS_OBSTRUCTED)) {
            status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_OBSTRUCTED));
        }
        if (!localStatusTypes.isEmpty()) {
            this.logWarning("the following svn statuses are not taken into account: " + localStatusTypes);
        }
        remoteStatusTypes.remove(SVNStatusType.STATUS_NONE);
        if (!remoteStatusTypes.isEmpty() && entry.reportOutOfDate()) {
            status.append(symbols.getOutOfDateSymbol());
        }
        return status.toString();
    }

    private void logInfo(CharSequence message) {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info(message);
        }
    }

    private void logWarning(CharSequence message) {
        if (this.getLog().isWarnEnabled()) {
            this.getLog().warn(message);
        }
    }

    private void logDebug(CharSequence message) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug(message);
        }
    }

    private void logDebugInfo(CharSequence message) {
        if (this.verbose) {
            this.logInfo(message);
        } else {
            this.logDebug(message);
        }
    }

    static {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
    }

    private final class SpecialEntryStatusHandler
    extends AbstractStatusHandler {
        private final String entryName;

        private SpecialEntryStatusHandler(String entryName) {
            if (entryName == null) {
                throw new IllegalArgumentException("entryName is null");
            }
            this.entryName = entryName;
        }

        public void handleStatus(SVNStatus status) {
            SVNEntry svnEntry = status.getEntry();
            if (svnEntry != null && this.entryName.equals(svnEntry.getName())) {
                this.setRepositoryProperties(svnEntry);
                this.appendStatus(status);
            }
        }
    }

    private final class VersionedEntryStatusHandler
    extends AbstractStatusHandler {
        private VersionedEntryStatusHandler() {
        }

        public void handleStatus(SVNStatus status) {
            this.appendStatus(status);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractStatusHandler
    implements ISVNStatusHandler {
        private String repositoryRoot = "";
        private String repositoryPath = "";
        private long maximumRevisionNumber = Long.MIN_VALUE;
        private long minimumRevisionNumber = Long.MAX_VALUE;
        private long maximumCommittedRevisionNumber = Long.MIN_VALUE;
        private Date maximumCommittedRevisionDate;
        private final Set<SVNStatusType> localStatusTypes = new HashSet<SVNStatusType>();
        private final Set<SVNStatusType> remoteStatusTypes = new HashSet<SVNStatusType>();

        private AbstractStatusHandler() {
        }

        protected void setRepositoryProperties(SVNEntry svnEntry) {
            this.repositoryRoot = svnEntry == null ? "" : svnEntry.getRepositoryRoot();
            String string = this.repositoryPath = svnEntry == null || svnEntry.getURL() == null ? "" : svnEntry.getURL().substring(this.repositoryRoot.length());
            if (this.repositoryPath.startsWith("/")) {
                this.repositoryPath = this.repositoryPath.substring(1);
            }
        }

        protected void appendStatus(SVNStatus status) {
            long committedRevisionNumber;
            long revisionNumber = status.getRevision().getNumber();
            if (SVNRevision.isValidRevisionNumber((long)revisionNumber)) {
                if (this.maximumRevisionNumber < revisionNumber) {
                    this.maximumRevisionNumber = revisionNumber;
                }
                if (revisionNumber != 0L && this.minimumRevisionNumber > revisionNumber) {
                    this.minimumRevisionNumber = revisionNumber;
                }
            }
            if (SVNRevision.isValidRevisionNumber((long)(committedRevisionNumber = status.getCommittedRevision().getNumber())) && this.maximumCommittedRevisionNumber < committedRevisionNumber) {
                this.maximumCommittedRevisionNumber = committedRevisionNumber;
                this.maximumCommittedRevisionDate = status.getCommittedDate();
            }
            SVNStatusType contentsStatusType = status.getContentsStatus();
            this.localStatusTypes.add(contentsStatusType);
            SVNStatusType propertiesStatusType = status.getPropertiesStatus();
            this.localStatusTypes.add(propertiesStatusType);
            SVNStatusType remoteContentsStatusType = status.getRemoteContentsStatus();
            this.remoteStatusTypes.add(remoteContentsStatusType);
            SVNStatusType remotePropertiesStatusType = status.getRemotePropertiesStatus();
            this.remoteStatusTypes.add(remotePropertiesStatusType);
            boolean entryOutOfDate = !SVNStatusType.STATUS_NONE.equals(remoteContentsStatusType) || !SVNStatusType.STATUS_NONE.equals(remotePropertiesStatusType);
            StringBuilder buffer = new StringBuilder();
            buffer.append("  ");
            buffer.append(contentsStatusType.getCode()).append(propertiesStatusType.getCode());
            buffer.append(entryOutOfDate ? (char)'*' : ' ');
            buffer.append(' ').append(String.format("%6d", revisionNumber));
            buffer.append(' ').append(String.format("%6d", committedRevisionNumber));
            buffer.append(' ').append(status.getFile());
            RevisionMojo.this.logDebugInfo(buffer.toString());
        }

        public String getRepositoryRoot() {
            return this.repositoryRoot;
        }

        public String getRepositoryPath() {
            return this.repositoryPath;
        }

        public long getMaximumRevisionNumber() {
            return this.maximumRevisionNumber == Long.MIN_VALUE ? -1L : this.maximumRevisionNumber;
        }

        public long getMinimumRevisionNumber() {
            return this.minimumRevisionNumber == Long.MAX_VALUE ? -1L : this.minimumRevisionNumber;
        }

        public boolean isMixedRevisions() {
            return this.getMaximumRevisionNumber() > 0L && this.getMinimumRevisionNumber() > 0L && this.getMaximumRevisionNumber() != this.getMinimumRevisionNumber();
        }

        public long getMaximumCommittedRevisionNumber() {
            return this.maximumCommittedRevisionNumber == Long.MIN_VALUE ? -1L : this.maximumCommittedRevisionNumber;
        }

        public String getMaximumCommittedRevisionDate() {
            return this.maximumCommittedRevisionDate == null ? "" : String.format(Locale.ENGLISH, "%tF %<tT %<tz (%<ta, %<td %<tb %<tY)", this.maximumCommittedRevisionDate);
        }

        public Set<SVNStatusType> getLocalStatusTypes() {
            return new HashSet<SVNStatusType>(this.localStatusTypes);
        }

        public Set<SVNStatusType> getRemoteStatusTypes() {
            return new HashSet<SVNStatusType>(this.remoteStatusTypes);
        }
    }
}

