/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function;

import com.googlecode.aviator.BaseExpression;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.runtime.FunctionParam;
import com.googlecode.aviator.runtime.RuntimeUtils;
import com.googlecode.aviator.runtime.function.AbstractVariadicFunction;
import com.googlecode.aviator.runtime.type.AviatorJavaType;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorRuntimeJavaType;
import com.googlecode.aviator.runtime.type.AviatorType;
import com.googlecode.aviator.utils.Env;
import java.util.List;
import java.util.Map;

public final class LambdaFunction
extends AbstractVariadicFunction {
    private static final long serialVersionUID = -4388339706945053452L;
    protected List<FunctionParam> params;
    protected BaseExpression expression;
    protected Env context;
    private boolean inheritEnv = false;
    private final boolean isVariadic;
    private final String name;

    public boolean isInheritEnv() {
        return this.inheritEnv;
    }

    public Env getContext() {
        return this.context;
    }

    public void setContext(Env context) {
        this.context = context;
    }

    public LambdaFunction(String name, List<FunctionParam> params, Expression expression, Env context) {
        this.name = name;
        this.params = params;
        this.context = context;
        this.expression = (BaseExpression)expression;
        this.isVariadic = !this.params.isEmpty() ? this.params.get(this.params.size() - 1).isVariadic() : false;
    }

    public BaseExpression getExpression() {
        return this.expression;
    }

    public void setInheritEnv(boolean inheritEnv) {
        this.inheritEnv = inheritEnv;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getArity() {
        return this.params.size();
    }

    public boolean isVariadic() {
        return this.isVariadic;
    }

    @Override
    public AviatorObject call(Map<String, Object> env) {
        return AviatorRuntimeJavaType.valueOf(this.expression.executeDirectly(this.newEnv(env, new AviatorObject[0])));
    }

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1) {
        return AviatorRuntimeJavaType.valueOf(this.expression.executeDirectly(this.newEnv(env, arg1)));
    }

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
        return AviatorRuntimeJavaType.valueOf(this.expression.executeDirectly(this.newEnv(env, arg1, arg2)));
    }

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2, AviatorObject arg3) {
        return AviatorRuntimeJavaType.valueOf(this.expression.executeDirectly(this.newEnv(env, arg1, arg2, arg3)));
    }

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2, AviatorObject arg3, AviatorObject arg4) {
        return AviatorRuntimeJavaType.valueOf(this.expression.executeDirectly(this.newEnv(env, arg1, arg2, arg3, arg4)));
    }

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2, AviatorObject arg3, AviatorObject arg4, AviatorObject arg5) {
        return AviatorRuntimeJavaType.valueOf(this.expression.executeDirectly(this.newEnv(env, arg1, arg2, arg3, arg4, arg5)));
    }

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2, AviatorObject arg3, AviatorObject arg4, AviatorObject arg5, AviatorObject arg6) {
        return AviatorRuntimeJavaType.valueOf(this.expression.executeDirectly(this.newEnv(env, arg1, arg2, arg3, arg4, arg5, arg6)));
    }

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2, AviatorObject arg3, AviatorObject arg4, AviatorObject arg5, AviatorObject arg6, AviatorObject arg7) {
        return AviatorRuntimeJavaType.valueOf(this.expression.executeDirectly(this.newEnv(env, arg1, arg2, arg3, arg4, arg5, arg6, arg7)));
    }

    protected Map<String, Object> newEnv(Map<String, Object> parentEnv, AviatorObject ... args) {
        Env env = null;
        if (!this.inheritEnv) {
            Env contextEnv = new Env(parentEnv, this.context);
            contextEnv.configure(this.context.getInstance(), this.expression);
            env = new Env(contextEnv);
            env.configure(this.context.getInstance(), this.expression);
        } else {
            assert (parentEnv == this.context);
            env = (Env)parentEnv;
        }
        if (args.length != this.params.size()) {
            throw new IllegalArgumentException("Wrong number of args(" + args.length + ") passed to " + this.getName() + "(" + this.params.size() + ")");
        }
        for (int i = 0; i < this.params.size(); ++i) {
            FunctionParam param = this.params.get(i);
            AviatorObject arg = args[i];
            Object value = arg.getValue(parentEnv);
            if (value == null && arg.getAviatorType() == AviatorType.JavaType && !parentEnv.containsKey(((AviatorJavaType)arg).getName())) {
                value = RuntimeUtils.getInstance(parentEnv).getFunction(((AviatorJavaType)arg).getName());
            }
            env.override(param.getName(), value);
        }
        return env;
    }

    @Override
    public AviatorObject variadicCall(Map<String, Object> env, AviatorObject ... args) {
        return AviatorRuntimeJavaType.valueOf(this.expression.executeDirectly(this.newEnv(env, args)));
    }
}

