/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.type;

import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorString;
import com.googlecode.aviator.runtime.type.AviatorType;
import com.googlecode.aviator.utils.TypeUtils;
import java.util.Map;

public class AviatorNil
extends AviatorObject {
    private static final long serialVersionUID = 5030890238879926682L;
    public static final AviatorNil NIL = new AviatorNil();

    private AviatorNil() {
    }

    @Override
    public AviatorObject add(AviatorObject other, Map<String, Object> env) {
        switch (other.getAviatorType()) {
            case String: {
                return new AviatorString("null" + other.getValue(env));
            }
            case JavaType: {
                Object otherValue = other.getValue(env);
                if (TypeUtils.isString(otherValue)) {
                    return new AviatorString("null" + otherValue);
                }
                return super.add(other, env);
            }
        }
        return super.add(other, env);
    }

    @Override
    public int innerCompare(AviatorObject other, Map<String, Object> env) {
        switch (other.getAviatorType()) {
            case Nil: {
                return 0;
            }
            case JavaType: {
                if (other.getValue(env) != null) break;
                return 0;
            }
        }
        return -1;
    }

    @Override
    public AviatorType getAviatorType() {
        return AviatorType.Nil;
    }

    @Override
    public Object getValue(Map<String, Object> env) {
        return null;
    }
}

