/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.type.seq;

import com.googlecode.aviator.runtime.type.Collector;
import com.googlecode.aviator.runtime.type.seq.AbstractSequence;
import com.googlecode.aviator.runtime.type.seq.ListCollector;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MapSequence
extends AbstractSequence<Map.Entry> {
    private final Map map;

    public MapSequence(Map map) {
        this.map = map;
    }

    @Override
    public int hintSize() {
        return this.map.size();
    }

    @Override
    public Collector newCollector(int size) {
        HashMap coll;
        if (size > 0) {
            return new ListCollector(size, false);
        }
        try {
            coll = (HashMap)this.map.getClass().newInstance();
        }
        catch (Throwable t) {
            coll = new HashMap();
        }
        final HashMap container = coll;
        return new Collector(){

            @Override
            public void add(Object e) {
                Map.Entry entry = (Map.Entry)e;
                container.put(entry.getKey(), entry.getValue());
            }

            @Override
            public Object getRawContainer() {
                return container;
            }
        };
    }

    @Override
    public Iterator<Map.Entry> iterator() {
        return this.map.entrySet().iterator();
    }
}

