/*
 * Decompiled with CFR 0.152.
 */
package com.relativitas.maven.plugins.formatter;

import com.relativitas.maven.plugins.formatter.ConfigReadException;
import com.relativitas.maven.plugins.formatter.ConfigReader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import org.codehaus.plexus.components.io.resources.PlexusIoFileResource;
import org.codehaus.plexus.components.io.resources.PlexusIoFileResourceCollection;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.xml.sax.SAXException;

public class FormatterMojo
extends AbstractMojo {
    private static final String CACHE_PROPERTIES_FILENAME = "maven-java-formatter-cache.properties";
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/*.java"};
    static final String LINE_ENDING_AUTO = "AUTO";
    static final String LINE_ENDING_KEEP = "KEEP";
    static final String LINE_ENDING_LF = "LF";
    static final String LINE_ENDING_CRLF = "CRLF";
    static final String LINE_ENDING_CR = "CR";
    static final String LINE_ENDING_LF_CHAR = "\n";
    static final String LINE_ENDING_CRLF_CHARS = "\r\n";
    static final String LINE_ENDING_CR_CHAR = "\r";
    private ResourceManager resourceManager;
    private File sourceDirectory;
    private File testSourceDirectory;
    private File targetDirectory;
    private File basedir;
    private File[] directories;
    private String[] includes;
    private String[] excludes;
    private String compilerSource;
    private String compilerCompliance;
    private String compilerTargetPlatform;
    private String encoding;
    private String lineEnding;
    private String configFile;
    private Boolean overrideConfigCompilerVersion;
    private CodeFormatter formatter;
    private PlexusIoFileResourceCollection collection;

    public void execute() throws MojoExecutionException {
        long startClock = System.currentTimeMillis();
        if (StringUtils.isEmpty((String)this.encoding)) {
            this.encoding = ReaderFactory.FILE_ENCODING;
            this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding (" + this.encoding + ") to format source files, i.e. build is platform dependent!"));
        } else {
            try {
                "Test Encoding".getBytes(this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new MojoExecutionException("Encoding '" + this.encoding + "' is not supported");
            }
            this.getLog().info((CharSequence)("Using '" + this.encoding + "' encoding to format source files."));
        }
        if (!(LINE_ENDING_AUTO.equals(this.lineEnding) || LINE_ENDING_KEEP.equals(this.lineEnding) || LINE_ENDING_LF.equals(this.lineEnding) || LINE_ENDING_CRLF.equals(this.lineEnding) || LINE_ENDING_CR.equals(this.lineEnding))) {
            throw new MojoExecutionException("Unknown value for lineEnding parameter");
        }
        this.createResourceCollection();
        ArrayList files = new ArrayList();
        try {
            if (this.directories != null) {
                for (File directory : this.directories) {
                    if (!directory.exists() || !directory.isDirectory()) continue;
                    this.collection.setBaseDir(directory);
                    this.addCollectionFiles(files);
                }
            } else {
                if (this.sourceDirectory != null && this.sourceDirectory.exists() && this.sourceDirectory.isDirectory()) {
                    this.collection.setBaseDir(this.sourceDirectory);
                    this.addCollectionFiles(files);
                }
                if (this.testSourceDirectory != null && this.testSourceDirectory.exists() && this.testSourceDirectory.isDirectory()) {
                    this.collection.setBaseDir(this.testSourceDirectory);
                    this.addCollectionFiles(files);
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to find files using includes/excludes", (Exception)e);
        }
        int numberOfFiles = files.size();
        Log log = this.getLog();
        log.info((CharSequence)("Number of files to be formatted: " + numberOfFiles));
        if (numberOfFiles > 0) {
            this.createCodeFormatter();
            ResultCollector rc = new ResultCollector();
            Properties hashCache = this.readFileHashCacheFile();
            String basedirPath = this.getBasedirPath();
            int n = files.size();
            for (int i = 0; i < n; ++i) {
                File file = (File)files.get(i);
                this.formatFile(file, rc, hashCache, basedirPath);
            }
            this.storeFileHashCache(hashCache);
            long endClock = System.currentTimeMillis();
            log.info((CharSequence)("Successfully formatted: " + rc.successCount + " file(s)"));
            log.info((CharSequence)("Fail to format        : " + rc.failCount + " file(s)"));
            log.info((CharSequence)("Skipped               : " + rc.skippedCount + " file(s)"));
            log.info((CharSequence)("Approximate time taken: " + (endClock - startClock) / 1000L + "s"));
        }
    }

    void createResourceCollection() {
        this.collection = new PlexusIoFileResourceCollection();
        if (this.includes != null && this.includes.length > 0) {
            this.collection.setIncludes(this.includes);
        } else {
            this.collection.setIncludes(DEFAULT_INCLUDES);
        }
        this.collection.setExcludes(this.excludes);
        this.collection.setIncludingEmptyDirectories(false);
        IncludeExcludeFileSelector fileSelector = new IncludeExcludeFileSelector();
        fileSelector.setIncludes(DEFAULT_INCLUDES);
        this.collection.setFileSelectors(new FileSelector[]{fileSelector});
    }

    void addCollectionFiles(List files) throws IOException {
        Iterator resources = this.collection.getResources();
        while (resources.hasNext()) {
            PlexusIoFileResource resource = (PlexusIoFileResource)resources.next();
            files.add(resource.getFile());
        }
    }

    private String getBasedirPath() {
        try {
            return this.basedir.getCanonicalPath();
        }
        catch (Exception e) {
            return "";
        }
    }

    private void storeFileHashCache(Properties props) {
        File cacheFile = new File(this.targetDirectory, CACHE_PROPERTIES_FILENAME);
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(cacheFile));
            props.store(out, null);
        }
        catch (FileNotFoundException e) {
            this.getLog().warn((CharSequence)"Cannot store file hash cache properties file", (Throwable)e);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Cannot store file hash cache properties file", (Throwable)e);
        }
    }

    private Properties readFileHashCacheFile() {
        Properties props = new Properties();
        Log log = this.getLog();
        if (!this.targetDirectory.exists()) {
            this.targetDirectory.mkdirs();
        } else if (!this.targetDirectory.isDirectory()) {
            log.warn((CharSequence)"Something strange here as the supposedly target directory is not a directory.");
            return props;
        }
        File cacheFile = new File(this.targetDirectory, CACHE_PROPERTIES_FILENAME);
        if (!cacheFile.exists()) {
            return props;
        }
        try {
            props.load(new BufferedInputStream(new FileInputStream(cacheFile)));
        }
        catch (FileNotFoundException e) {
            log.warn((CharSequence)"Cannot load file hash cache properties file", (Throwable)e);
        }
        catch (IOException e) {
            log.warn((CharSequence)"Cannot load file hash cache properties file", (Throwable)e);
        }
        return props;
    }

    private void formatFile(File file, ResultCollector rc, Properties hashCache, String basedirPath) {
        try {
            this.doFormatFile(file, rc, hashCache, basedirPath);
        }
        catch (IOException e) {
            rc.failCount++;
            this.getLog().warn((Throwable)e);
        }
        catch (MalformedTreeException e) {
            rc.failCount++;
            this.getLog().warn((Throwable)e);
        }
        catch (BadLocationException e) {
            rc.failCount++;
            this.getLog().warn((Throwable)e);
        }
    }

    private void doFormatFile(File file, ResultCollector rc, Properties hashCache, String basedirPath) throws IOException, BadLocationException {
        Log log = this.getLog();
        log.debug((CharSequence)("Processing file: " + file));
        String code = this.readFileAsString(file);
        String originalHash = this.md5hash(code);
        String canonicalPath = file.getCanonicalPath();
        String path = canonicalPath.substring(basedirPath.length());
        String cachedHash = hashCache.getProperty(path);
        if (cachedHash != null && cachedHash.equals(originalHash)) {
            rc.skippedCount++;
            log.debug((CharSequence)"File is already formatted.");
            return;
        }
        String lineSeparator = this.getLineEnding(code);
        TextEdit te = this.formatter.format(4104, code, 0, code.length(), 0, lineSeparator);
        if (te == null) {
            rc.skippedCount++;
            log.debug((CharSequence)"Code cannot be formatted. Possible cause is unmatched source/target/compliance version.");
            return;
        }
        Document doc = new Document(code);
        te.apply((IDocument)doc);
        String formattedCode = doc.get();
        String formattedHash = this.md5hash(formattedCode);
        hashCache.setProperty(path, formattedHash);
        if (originalHash.equals(formattedHash)) {
            rc.skippedCount++;
            log.debug((CharSequence)"Equal hash code. Not writing result to file.");
            return;
        }
        this.writeStringToFile(formattedCode, file);
        rc.successCount++;
    }

    private String md5hash(String str) throws UnsupportedEncodingException {
        return DigestUtils.md5Hex((byte[])str.getBytes(this.encoding));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFileAsString(File file) throws IOException {
        StringBuilder fileData = new StringBuilder(1000);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(ReaderFactory.newReader((File)file, (String)this.encoding));
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
                buf = new char[1024];
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(reader);
            throw throwable;
        }
        IOUtil.close((Reader)reader);
        return fileData.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStringToFile(String str, File file) throws IOException {
        if (!file.exists() && file.isDirectory()) {
            return;
        }
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(WriterFactory.newWriter((File)file, (String)this.encoding));
            bw.write(str);
        }
        catch (Throwable throwable) {
            IOUtil.close(bw);
            throw throwable;
        }
        IOUtil.close((Writer)bw);
    }

    private void createCodeFormatter() throws MojoExecutionException {
        Map options = this.getFormattingOptions();
        this.formatter = ToolFactory.createCodeFormatter((Map)options);
    }

    private Map getFormattingOptions() throws MojoExecutionException {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("org.eclipse.jdt.core.compiler.source", this.compilerSource);
        options.put("org.eclipse.jdt.core.compiler.compliance", this.compilerCompliance);
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", this.compilerTargetPlatform);
        if (this.configFile != null) {
            Map config = this.getOptionsFromConfigFile();
            if (Boolean.TRUE.equals(this.overrideConfigCompilerVersion)) {
                config.remove("org.eclipse.jdt.core.compiler.source");
                config.remove("org.eclipse.jdt.core.compiler.compliance");
                config.remove("org.eclipse.jdt.core.compiler.codegen.targetPlatform");
            }
            options.putAll(config);
        }
        return options;
    }

    private Map getOptionsFromConfigFile() throws MojoExecutionException {
        InputStream configInput = null;
        try {
            this.resourceManager.addSearchPath("file", this.basedir.getAbsolutePath());
            configInput = this.resourceManager.getResourceAsInputStream(this.configFile);
        }
        catch (ResourceNotFoundException e) {
            throw new MojoExecutionException("Config file [" + this.configFile + "] cannot be found", (Exception)((Object)e));
        }
        if (configInput == null) {
            throw new MojoExecutionException("Config file [" + this.configFile + "] does not exist");
        }
        try {
            ConfigReader configReader = new ConfigReader();
            Map map = configReader.read(configInput);
            return map;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot read config file [" + this.configFile + "]", (Exception)e);
        }
        catch (SAXException e) {
            throw new MojoExecutionException("Cannot parse config file [" + this.configFile + "]", (Exception)e);
        }
        catch (ConfigReadException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        finally {
            if (configInput != null) {
                try {
                    configInput.close();
                }
                catch (IOException e) {}
            }
        }
    }

    String getLineEnding(String fileDataString) {
        String lineEnd = null;
        if (LINE_ENDING_KEEP.equals(this.lineEnding)) {
            lineEnd = this.determineLineEnding(fileDataString);
        } else if (LINE_ENDING_LF.equals(this.lineEnding)) {
            lineEnd = LINE_ENDING_LF_CHAR;
        } else if (LINE_ENDING_CRLF.equals(this.lineEnding)) {
            lineEnd = LINE_ENDING_CRLF_CHARS;
        } else if (LINE_ENDING_CR.equals(this.lineEnding)) {
            lineEnd = LINE_ENDING_CR_CHAR;
        }
        return lineEnd;
    }

    String determineLineEnding(String fileDataString) {
        int lfCount = 0;
        int crCount = 0;
        int crlfCount = 0;
        for (int i = 0; i < fileDataString.length(); ++i) {
            char c = fileDataString.charAt(i);
            if (c == '\r') {
                if (i + 1 < fileDataString.length() && fileDataString.charAt(i + 1) == '\n') {
                    ++crlfCount;
                    ++i;
                    continue;
                }
                ++crCount;
                continue;
            }
            if (c != '\n') continue;
            ++lfCount;
        }
        if (lfCount > crCount && lfCount > crlfCount) {
            return LINE_ENDING_LF_CHAR;
        }
        if (crlfCount > lfCount && crlfCount > crCount) {
            return LINE_ENDING_CRLF_CHARS;
        }
        if (crCount > lfCount && crCount > crlfCount) {
            return LINE_ENDING_CR_CHAR;
        }
        return null;
    }

    private class ResultCollector {
        private int successCount;
        private int failCount;
        private int skippedCount;

        private ResultCollector() {
        }
    }
}

